/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SelectionModel.h"


namespace U2 {

void MultiGSelection::addSelection(const GSelection* s) {
    assert(!selections.contains(s));
    selections.push_back(s);
}

void MultiGSelection::removeSelection(const GSelection* s) {
    assert(selections.contains(s));
    selections.removeAll(s);
}


const GSelection* MultiGSelection::findSelectionByType(GSelectionType t) const {
    foreach(const GSelection* s, selections) {
        if (s->getSelectionType() == t) {
            return s;
        }
    }
    return NULL;
}



}//namespace
