/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_TASK_MAPPER_H_
#define _U2_TASK_MAPPER_H_

#include <U2Core/Task.h>

namespace U2
{

class U2CORE_EXPORT TaskSignalMapper : public QObject {
    Q_OBJECT
public:
    TaskSignalMapper(QObject* parent = NULL) : QObject(parent) {}
    TaskSignalMapper(Task* t) : QObject(t) {
        connect(t, SIGNAL(si_stateChanged()), SLOT(sl_taskStateChanged()));
    }
public slots:
    void sl_taskStateChanged();
signals:
    void si_taskPrepared(Task*);
    void si_taskRunning(Task*);
    void si_taskFinished(Task*);
    void si_taskSucceeded(Task*);
    void si_taskFailed(Task*);
};

} //namespace

#endif 
