/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AnnotationUtils.h"

namespace U2 {

    int AnnotationUtils::getRegionFrame(int sequenceLen, bool complement, bool order, int region, const QList<LRegion>& location) {
        int frame = 0;
        const LRegion& r = location.at(region);
        if (complement) {
            frame = (sequenceLen - r.endPos()) % 3;
        } else {
            frame = r.startPos % 3;
        }
        if (!order){ //join -> need to join region with prev regions to derive frame
            if (complement) {
                int offset = 0;
                for (int i = location.length(); --i > region;) {
                    const LRegion& rb = location.at(i);
                    offset += rb.len;
                }
                int dFrame = offset % 3;
                frame = (frame + (3 - dFrame)) % 3;
            } else {
                int offset = 0;
                for (int i = 0; i < region; i++) {
                    const LRegion& rb = location.at(i);
                    offset += rb.len;
                }
                int dFrame = offset % 3;
                frame = (frame + (3 - dFrame)) % 3;
            }
        }
        return frame;
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    ///////// Below is copy-pasted code for old data model. See U2AnnotationUtils. ///////////
    /////////////////////////////////////////////////////////////////////////////////////////

QList<LRegion> AnnotationUtils::fixLocationsForRemovedRegion( const LRegion& regionToDelete, 
                                                               QList<LRegion>& regionList, 
                                                               AnnotationStrategyForResize s )
{
    //assert (s == AnnotationStrategyForResize_Remove || s == AnnotationStrategyForResize_Resize);
    QList<LRegion> toDelete, toReplace;
    foreach(LRegion reg, regionList){
        toDelete.append(reg);
        if (s != AnnotationStrategyForResize_Remove){
            if(reg.contains(regionToDelete)){
                reg.len -= regionToDelete.len;
            }else if (regionToDelete.contains(reg)) {
                reg.len = 0;
            }else if(reg.intersects(regionToDelete)){
                if(reg.startPos <= regionToDelete.startPos){
                    reg.len -= reg.endPos() - regionToDelete.startPos;
                }else{
                    reg.len -= regionToDelete.endPos() - reg.startPos;
                    reg.startPos = regionToDelete.startPos;
                }
            }else if(reg.startPos >= regionToDelete.endPos()){
                reg.startPos -= regionToDelete.len;
            } 
        }
        else {
            if(reg.intersects(regionToDelete) || regionToDelete.contains(reg)){
                reg.len = 0;
            }else if(reg.startPos >= regionToDelete.endPos()){
                reg.startPos -= regionToDelete.len;
            }
        }
        if (reg.len != 0) {
            toDelete.removeLast();
            toReplace.append(reg);
        }
    }
    regionList.clear();
    regionList.append(toReplace);

    return toDelete;
}

QList<LRegion> AnnotationUtils::fixLocationsForInsertedRegion( int insertPos, int len, 
                                                                QList<LRegion>& regionList, 
                                                                AnnotationStrategyForResize s )
{
    QList<LRegion> toReplace, toDelete;
    foreach(LRegion reg, regionList){
        if(reg.endPos() <= insertPos){
            toReplace.append(reg);
        } else {
            if (s == AnnotationStrategyForResize_Resize){
                if(reg.startPos < insertPos && reg.endPos() > insertPos){
                    reg.len += len;
                    toReplace.append(reg);
                }else if(reg.startPos >= insertPos){
                    reg.startPos += len;
                    toReplace.append(reg);
                }                                
            }else if(s == AnnotationStrategyForResize_Split){
                if(reg.startPos < insertPos && reg.endPos() > insertPos){
                    LRegion firstPart, secondPart;
                    firstPart.startPos = reg.startPos;
                    firstPart.len = insertPos - reg.startPos;
                    secondPart.startPos = firstPart.endPos() + len;
                    secondPart.len = reg.len - firstPart.len;
                    toReplace.append(firstPart);
                    toReplace.append(secondPart);
                }else if(reg.startPos >= insertPos){
                    reg.startPos += len;
                    toReplace.append(reg);
                }                                
            }else if(s == AnnotationStrategyForResize_Remove){
                if(reg.startPos < insertPos && reg.endPos() > insertPos){
                    toDelete.append(reg);
                }else if(reg.startPos >= insertPos){
                    reg.startPos += len;
                    toReplace.append(reg);
                }                                
            }
        }
    }
    regionList.clear();
    regionList.append(toReplace);
    return toDelete;
}

QList<LRegion> AnnotationUtils::fixLocationsForReplacedRegion( const LRegion& regionToReplace, 
                                                                int newLen, QList<LRegion>& loc, 
                                                                AnnotationStrategyForResize s )
{
    if (s == AnnotationStrategyForResize_Remove) {
        QList<LRegion> l1 = fixLocationsForRemovedRegion(regionToReplace, loc, s);
        QList<LRegion> l2 = fixLocationsForInsertedRegion(regionToReplace.startPos, newLen, loc, s);
        assert(l2.isEmpty()); Q_UNUSED(l2);
        return l1;
    } else {
        int offset = newLen - regionToReplace.len;
        if (s == AnnotationStrategyForResize_Resize && offset == 0) {
            return QList<LRegion>();
        }
        assert(s == AnnotationStrategyForResize_Resize); // FIXME do we ever need to SPLIT when replacing ???
        
        QList<LRegion> toReplace, toDelete;
        foreach(LRegion reg, loc){
            LRegion copy = reg;
            if(reg.endPos() <= regionToReplace.startPos){
                toReplace.append(reg);
            } else {
                if (reg.contains(regionToReplace)) {
                    reg.len += offset;
                } else if (reg.startPos >= regionToReplace.endPos()) {
                    reg.startPos += offset;
                } else {
                    // start pos and/or end pos lie inside the regionToReplace
                    // let's assume offset is applied at the region end
                    if (offset > 0) {
                        if (reg.endPos() <= regionToReplace.endPos()) {
                            // leave it as is
                        } else {
                            // append tail
                            reg.len += offset;
                        }
                    } else {
                        if (reg.endPos() <= regionToReplace.endPos() + offset) {
                            // leave it as is
                        } else if (reg.startPos < regionToReplace.endPos() + offset && reg.endPos() >= regionToReplace.endPos()) {    
                            // crop inner subregion
                            reg.len += offset;
                        } else if (reg.startPos >= regionToReplace.endPos() + offset && reg.endPos() <= regionToReplace.endPos()) {
                            // drop the region
                            reg.len = 0;
                        } else if (reg.startPos < regionToReplace.endPos() + offset) {
                            // crop tail
                            assert(reg.endPos() < regionToReplace.endPos() && reg.endPos() > regionToReplace.endPos() + offset);
                            reg.len -= reg.endPos() - regionToReplace.startPos;
                        } else {
                            // crop head
                            assert(reg.startPos >= regionToReplace.endPos() + offset && reg.startPos < regionToReplace.endPos());
                            assert(reg.endPos() > regionToReplace.endPos());
                            reg.len = reg.endPos() - regionToReplace.endPos();
                            reg.startPos = regionToReplace.endPos() + offset;
                        }
                    }
                }
                assert(reg.len >= 0);
                if (reg.len == 0) {
                    toDelete.append(reg);
                } else {
                    toReplace.append(reg);
                }
            }
        }
        loc.clear();
        loc.append(toReplace);
        return toDelete;
    }
}

} //ns
