/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_SCF_FORMAT_H_
#define _U2_SCF_FORMAT_H_

#include <U2Core/BaseDocumentFormats.h>
#include <U2Core/DocumentModel.h>

namespace U2 {

class IOAdapter;
class SeekableBuf;
class DNAChromatogram;
class DNASequence;

class U2FORMATS_EXPORT  SCFFormat : public DocumentFormat {
    Q_OBJECT
public:
    SCFFormat(QObject* p);

    virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::SCF;}

    virtual const QString& getFormatName() const {return formatName;}

    virtual Document* loadDocument(IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);

    virtual FormatDetectionResult checkRawData(const QByteArray& rawData) const;

    static void exportDocumentToSCF(const QString& fileName, const DNAChromatogram& cd, const DNASequence& dna, TaskStateInfo& ts);

private:
    Document* parseSCF(SeekableBuf*, IOAdapterFactory* io, const GUrl& url, const QVariantMap& fs);

    QString formatName;
};

}//namespace

#endif
