/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_BASE_DOC_FORMAT_CONFIG_H_
#define _U2_BASE_DOC_FORMAT_CONFIG_H_

#include <U2Core/global.h>
#include <U2Core/DocumentFormatConfigurators.h>

namespace U2 {

class U2GUI_EXPORT BaseDocumentFormatConfigurators  {
public:
    static void initBuiltInConfigurators();

    static void loadDefaultFormatSettings(const DocumentFormatId& format, QVariantMap& formatSettings);
    static void saveDefaultFormatSettings(const DocumentFormatId& format, const QVariantMap& formatSettings);

};

class U2GUI_EXPORT MultiPartDocFormatConfigurator : public DocumentFormatConfigurator {
    Q_OBJECT
public:
    MultiPartDocFormatConfigurator(DocumentFormatId id) : DocumentFormatConfigurator(id) {};

    virtual void configure(QVariantMap& info);


};


}//namespace
#endif
