/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_EDIT_SEQUENCE_CONTROLLER_H_
#define _U2_EDIT_SEQUENCE_CONTROLLER_H_

#include <U2Core/LRegion.h>
#include <U2Core/AnnotationUtils.h>
#include <U2Core/GUrl.h>
#include <U2Gui/SeqPasterWidgetController.h>
#include <U2Misc/DialogUtils.h>

#include <QtGui/QDialog>

class Ui_EditSequenceDialog;

namespace U2{

enum EditSequenceDialogMode {
    EditSequenceMode_Replace,
    EditSequenceMode_Insert
};


struct U2GUI_EXPORT EditSequencDialogConfig {
    EditSequenceDialogMode mode;
    LRegion source;
    DNAAlphabet* alphabet;
    QByteArray initialText;
};

class U2GUI_EXPORT EditSequenceDialogController : public QDialog {
    Q_OBJECT
public:
    EditSequenceDialogController(EditSequencDialogConfig cfg, QWidget *p = NULL);
    ~EditSequenceDialogController();
    virtual void accept();

    DNASequence getNewSequence(){return w->getSequence();};
    GUrl getDocumentPath(); 
    int getPosToInsert(){return pos;};
    AnnotationUtils::AnnotationStrategyForResize getAnnotationStrategy();
    bool mergeAnnotations();
    DocumentFormatId getDocumentFormatId();
private slots:
    void sl_browseButtonClicked();
    void sl_indexChanged(int);
    void sl_mergeAnnotationsToggled(bool);

private:
    void addSeqpasterWidget();
    bool modifyCurrentDocument();


    QString filter;
    int pos;
    SeqPasterWidgetController *w;
    EditSequencDialogConfig config;
    Ui_EditSequenceDialog* ui;
};

}//ns

#endif

