/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BioActorLibrary.h"

#include <U2Lang/WorkflowEnv.h>

#include "BioDatatypes.h"
#include "LocalDomain.h"

static const QString SEQ_SLOT_ID("sequence");
static const QString MA_SLOT_ID("msa");
static const QString FEATURE_TABLE_SLOT_ID("annotations");

namespace U2 {
namespace Workflow {

const Descriptor BioActorLibrary::SEQ_SLOT() {
    return Descriptor(SEQ_SLOT_ID, tr("Sequence"), tr("A biological sequence"));
}

const Descriptor BioActorLibrary::MA_SLOT() {
    return Descriptor(MA_SLOT_ID, tr("MSA"), tr("A multiple sequence alignment"));
}

const Descriptor BioActorLibrary::FEATURE_TABLE_SLOT() {
    return Descriptor(FEATURE_TABLE_SLOT_ID, tr("Set of annotations"), tr("A set of annotated regions"));
}

const QString BioActorLibrary::FILE_MODE_ATTR_ID("write-mode");

const Descriptor BioActorLibrary::FILE_MODE_ATTR() {
    return Descriptor(FILE_MODE_ATTR_ID, tr("Existing file"), tr("If a target file already exists, you can specify" 
                                                                 "how it should be handled: either overwritten, renamed" 
                                                                 " or appended (if supported by file format)."));
}

void BioActorLibrary::init() {
    WorkflowEnv::getDomainRegistry()->registerEntry(new LocalWorkflow::LocalDomainFactory());
}

}//Workflow namespace
}//GB2 namespace
