/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_CORE_DATATYPE_H_
#define _U2_CORE_DATATYPE_H_

#include <QtCore/QVariant>

#include <U2Lang/Datatype.h>

namespace U2 {

/**
 * container of primitive type id's
 * and types itself
 */
class U2LANG_EXPORT CoreDataTypes : public QObject {
    Q_OBJECT
public:
    static const QString STRING_TYPE_ID;
    static const QString STRING_SHORT_NAME;
    static const QString BOOL_TYPE_ID;
    static const QString NUM_TYPE_ID;
    static const QString ANY_TYPE_ID;
    
    static DataTypePtr STRING_TYPE();
    static DataTypePtr BOOL_TYPE();
    static DataTypePtr NUM_TYPE();
    
    static DataTypePtr ANY_TYPE();
    
}; // CoreDataTypes

// value factories for core datatypes

/**
 * DatatypeValueFactory realization for string type
 */
class StringTypeValueFactory : public DataTypeValueFactory {
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL  ) const;
    virtual QString getId() const { return CoreDataTypes::STRING_TYPE_ID; }

}; // StringTypeValueFactory

/**
 * DatatypeValueFactory realization for bool type
 */
class BoolTypeValueFactory : public DataTypeValueFactory {
public:
    static const QString TRUE_STR;
    static const QString FALSE_STR;
    static const QString YES_STR;
    static const QString NO_STR;
    static const QString ONE_STR;
    static const QString NIL_STR;
    
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL  ) const;
    virtual QString getId() const { return CoreDataTypes::BOOL_TYPE_ID; }

}; // BoolTypeValueFactory

/**
 * DatatypeValueFactory realization for num type
 */
class NumTypeValueFactory : public DataTypeValueFactory {
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL ) const;
    virtual QString getId() const { return CoreDataTypes::NUM_TYPE_ID; }

}; // NumTypeValueFactory

} //namespace
#endif
