/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_TREE_WIDGET_UTILS_H_
#define _U2_TREE_WIDGET_UTILS_H_

#include <U2Core/global.h>
#include <QtGui/QTreeWidget>

namespace U2{

class TreeWidgetVisitor {
public:
    virtual ~TreeWidgetVisitor(){}
    virtual bool isChildVisitRequired(QTreeWidgetItem*)  {return true;}
    virtual void visit(QTreeWidgetItem* item) = 0;
};

class U2MISC_EXPORT TreeWidgetUtils {

private:
    TreeWidgetUtils(){}

public:
    static void visitDFS(QTreeWidget* tree, TreeWidgetVisitor* visitor);
};


}

#endif
