/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_MSA_ALIGN_GUI_EXTENSION_H_
#define _U2_MSA_ALIGN_GUI_EXTENSION_H_


#include <U2Core/global.h>
#include <U2Core/GUrl.h>
#include <U2Core/Task.h>

#include <QtGui/QWidget>

namespace U2 {

// These classes are intended for extending standard MSA Align dialog GUI
// with options specific to the align algorithm

class MSAAlignAlgorithmMainWidget : public QWidget {
public:
    MSAAlignAlgorithmMainWidget(QWidget* parent) : QWidget(parent) {}
    virtual QMap<QString,QVariant> getMSAAlignCustomSettings() = 0;
};

class MSAAlignGUIExtensionsFactory {
public:
    virtual MSAAlignAlgorithmMainWidget* createMainWidget(QWidget* parent) = 0;
    virtual bool hasMainWidget() = 0;
};

} // U2

#endif // _U2_MSA_ALIGN_GUI_EXTENSION_H_
