/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ANNOTATED_DNA_VIEW_CLIPBOARD_H_
#define _U2_ANNOTATED_DNA_VIEW_CLIPBOARD_H_

#include <U2Core/global.h>
#include <U2Core/LRegion.h>

#include <QtGui/QAction>

namespace U2 {

class AnnotatedDNAView;
class LRegionsSelection;
class Annotation;
class AnnotationSelection;
class ADVSequenceObjectContext;
class ADVSequenceWidget;

class U2VIEW_EXPORT ADVClipboard: public QObject {
    Q_OBJECT
public:
    ADVClipboard(AnnotatedDNAView* ctx);

    QAction* getCopySequenceAction() const {return copySequenceAction;}
    QAction* getCopyTranslationAction() const {return copyTranslationAction;}
    QAction* getCopyComplementAction() const {return copyComplementSequenceAction;}
    QAction* getCopyComplementTranslationAction() const {return copyComplementTranslationAction;}

    QAction* getCopyAnnotationSequenceAction() const {return copyAnnotationSequenceAction;}
    QAction* getCopyAnnotationSequenceTranslationAction() const {return copyAnnotationSequenceTranslationAction;}

    void addCopyMenu(QMenu* m);

public slots:
    
    void sl_onDNASelectionChanged(LRegionsSelection* thiz, const QList<LRegion>& added, const QList<LRegion>& removed);
    void sl_onAnnotationSelectionChanged(AnnotationSelection* thiz, const QList<Annotation*>& added, const QList<Annotation*>& removed);
    void sl_onFocusedSequenceWidgetChanged(ADVSequenceWidget*, ADVSequenceWidget*);

    void sl_copySequence();
    void sl_copyTranslation();
    void sl_copyComplementSequence();
    void sl_copyComplementTranslation();
    void sl_copyAnnotationSequence();
    void sl_copyAnnotationSequenceTranslation();

    ADVSequenceObjectContext* getSequenceContext() const;

private:
    void connectSequence(ADVSequenceObjectContext* s);
    void updateActions();
    void copySequenceSelection(bool complement, bool amino);

    AnnotatedDNAView* ctx;
    QAction* copySequenceAction;
    QAction* copyTranslationAction;
    QAction* copyComplementSequenceAction;
    QAction* copyComplementTranslationAction;
    QAction* copyAnnotationSequenceAction;
    QAction* copyAnnotationSequenceTranslationAction;
};

}//namespace

#endif
