/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DET_VIEW_H_
#define _U2_DET_VIEW_H_

#include "GSequenceLineViewAnnotated.h"

#include <QtGui/QFont>
#include <QtGui/QAction>

class QActionGroup;

namespace U2 {

class DNATranslation;

class U2VIEW_EXPORT DetView : public GSequenceLineViewAnnotated {
    Q_OBJECT

public:
    DetView(QWidget* p, ADVSequenceObjectContext* ctx);

    bool isOneLineMode()  {return getComplementTT() == NULL && getAminoTT() == NULL;}
    bool hasTranslations()  {return getAminoTT() != NULL;}
    bool hasComplementStrand()  {return getComplementTT() != NULL;}
    
    DNATranslation* getComplementTT() const;
    DNATranslation* getAminoTT() const;

    void setShowComplement(bool t);
    void setShowTranslation(bool t);

    QAction* getShowComplementAction() const {return showComplementAction;}
    QAction* getShowTranslationAction() const {return showTranslationAction;}

protected slots:
    virtual void sl_sequenceChanged();
    void sl_onAminoTTChanged();
    void sl_showComplementToggle(bool v) {setShowComplement(v);}
    void sl_showTranslationToggle(bool v) {setShowTranslation(v);}

protected:
    void showEvent(QShowEvent * e);
    void hideEvent(QHideEvent * e);
    
    void mouseReleaseEvent(QMouseEvent* me);
    
    void updateActions();

    void resizeEvent(QResizeEvent *e);
    void updateSize();

    QAction*        showComplementAction;
    QAction*        showTranslationAction;
};


class DetViewRenderArea : public GSequenceLineViewAnnotatedRenderArea {
public:
    DetViewRenderArea(DetView* d);

    virtual int coordToPos(int x) const;
    virtual float posToCoordF(int x, bool useVirtualSpace = false) const;
    virtual float getCurrentScale() const;

    DetView* getDetView() const {return static_cast<DetView*>(view);}

    virtual LRegion getAnnotationYRange(Annotation* a, int region, const AnnotationSettings* as) const;
    
    void updateSize();

    bool isOnTranslationsLine(int y) const;

protected:
    virtual void drawAll(QPaintDevice* pd);


private:
    int getLineY(int line) const {return 2 + line * lineHeight;}
    int getTextY(int line) const {return getLineY(line) + lineHeight - yCharOffset;}

    void updateLines();
    void drawDirect(QPainter& p);
    void drawComplement(QPainter& p);
    void drawTranslations(QPainter& p);
    void drawSequenceSelection(QPainter& p);
    void drawRuler(QPainter& p);
    void highlight(QPainter& p, const LRegion& r, int line);

    int posToComplTransLine(int p) const;
    int posToDirectTransLine(int p) const;
    bool deriveTranslationCharColor(int pos, bool complement, QList<Annotation*> annotationsInRange, QColor& result);

    int numLines;
    int rulerLine;
    int baseLine;
    int complementLine;
    int firstDirectTransLine;
    int firstComplTransLine;
};


}//namespace;

#endif
