/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_CREATE_UINDEX_DLG_H_
#define _U2_CREATE_UINDEX_DLG_H_

#include <ui/ui_CreateFileIndexDialog.h>
#include <QtGui/QDialog>

namespace U2 {

    struct CreateFileIndexDialogModel {
        QStringList inputUrls;
        QString     outputUrl;
        bool        gzippedOutput;
        bool        addToProject;
    }; // CreateFileIndexDialogModel

    class CreateFileIndexDialog : public QDialog, Ui_CreateFileIndexDialog {
        Q_OBJECT
    public:
        CreateFileIndexDialog(QWidget* p, bool enableAddToProjButton);

        CreateFileIndexDialogModel getModel() const;

        virtual void accept();

    private:
        CreateFileIndexDialogModel model;

        private slots:
            void sl_openInputFile();
            void sl_openOutputFile();
    };

} // U2

#endif
