/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_CREATE_RECTANGULAR_BRANCHES_TASK_H_
#define _U2_CREATE_RECTANGULAR_BRANCHES_TASK_H_

#include "CreateBranchesTask.h"

namespace U2 {

class PhyNode;
class GraphicsRectangularBranchItem;

class CreateRectangularBranchesTask: public CreateBranchesTask {
    Q_OBJECT

    int size;
    int current;
    qreal scale;
    PhyNode* node;
    qreal minDistance, maxDistance;
    GraphicsRectangularBranchItem* getBranch(PhyNode *node);

public:
    CreateRectangularBranchesTask(PhyNode *n);
    void run();
    qreal getScale() { return scale; }
};

}//namespace;

#endif
