/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ANNOTATION_UTILS_H_
#define _U2_ANNOTATION_UTILS_H_

#include <U2Core/U2Annotation.h>

namespace U2 {

/**                                           
    U2Annotation and related structures utility functions
*/
class U2CORE_EXPORT U2AnnotationUtils : public QObject {
    Q_OBJECT
private:
    U2AnnotationUtils(){}
public:

    enum AnnotationStrategyForResize{
        AnnotationStrategyForResize_Resize, 
        AnnotationStrategyForResize_Remove,
        AnnotationStrategyForResize_Split
    };

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
        the returned list contains removed locations if any.
        If specified strategy is 'remove', removes all locations which intersect the removed region or fall inside it.
    */
    static QList<U2Region> fixLocationsForRemovedRegion(const U2Region& regionToDelete, QList<U2Region>& loc, AnnotationStrategyForResize s);

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
    the returned list contains removed locations if any.
    If specified strategy is 'remove', removes all locations which contain the insert position inside them.
    Note, if a region starts at the insert position, it is just moved to the right.
    */
    static QList<U2Region> fixLocationsForInsertedRegion(qint64 insertPos, qint64 len, QList<U2Region>& loc, AnnotationStrategyForResize s);

    /** Corrects annotation locations for a sequence. The passed list is updated with new locations, 
    the returned list contains removed locations if any.
    If specified strategy is 'remove', removes all locations which intersect the modified region or fall inside it.
    */
    static QList<U2Region> fixLocationsForReplacedRegion(const U2Region& regionToDelete, qint64 newLen, QList<U2Region>& loc, AnnotationStrategyForResize s);
};

} //namespace

#endif
