/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ASSEMBLY_UTILS_H_
#define _U2_ASSEMBLY_UTILS_H_

#include <U2Core/U2Assembly.h>

namespace U2 {

/**                                           
    U2Assembly and related structures utility functions
*/
class U2CORE_EXPORT U2AssemblyUtils : public QObject {
    Q_OBJECT
private:
    U2AssemblyUtils(){}
public:

    /** 
        Returns CIGAR operation for the given char, case insensitive 
        If failed, error text is stored in 'err'
    */
    static U2CigarOp char2Cigar(char c, QString& err);

    /** 
        Returns char representation of the given CIGAR op
    */
    static char cigar2Char(U2CigarOp op);

    /** 
        Parses CIGAR string (SAM/BAM format specs) 
        Returns the result as a set of U2CigarTokens.
        If parsing is failed, the fail reason is stored in 'err' parameter
    */
    static QList<U2CigarToken> parseCigar(const QByteArray& cigarString, QString& err);

    /**
        Returns string representation of the CIGAR
    */
    static QString cigar2String(const QList<U2CigarToken>& cigar);


    /** 
        Returns extra read length produced by CIGAR. Can be negative.
    */
    static qint64 getCigarExtraLength(const QList<U2CigarToken>& cigar);
};


} //namespace

#endif
