/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DNA_STAT_PLUGIN_H_
#define _U2_DNA_STAT_PLUGIN_H_

#include <U2Core/PluginModel.h>
#include <U2Gui/ObjectViewModel.h>

namespace U2 {

class DNAStatPlugin : public Plugin {
    Q_OBJECT
public:
    DNAStatPlugin();

private:
    GObjectViewWindowContext* statViewCtx;
    GObjectViewWindowContext* distanceViewCtx;
};

class DNAStatMSAEditorContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    DNAStatMSAEditorContext(QObject* p);

protected slots:
    void sl_showMSAProfileDialog();
    void buildMenu(GObjectView* v, QMenu* m);
protected:
    virtual void initViewContext(GObjectView* view);
};

class DistanceMatrixMSAEditorContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    DistanceMatrixMSAEditorContext(QObject* p);

protected slots:
    void sl_showDistanceMatrixDialog();
    void buildMenu(GObjectView* v, QMenu* m);
protected:
    virtual void initViewContext(GObjectView* view);
};


} //namespace

#endif

