/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DNA_FRAGMENT_H_
#define _U2_DNA_FRAGMENT_H_

#include <QtCore/QList>


#include <U2Core/LRegion.h>


namespace U2 {

class DNASequenceObject;
class DNAAlphabet;
class AnnotationTableObject;
class Annotation;
class GObject;

class DNAFragment {
private:
    // Contains fragment region and cuts info
    Annotation* annotatedFragment;
    // Parent sequence of the fragment
    DNASequenceObject* dnaObj;
    // Annotations associated with parent sequence
    // When ligate or export fragments they must be saved
    QList<AnnotationTableObject*> relatedAnnotations;
    bool isSplitted() const;
public:
    DNAFragment() : annotatedFragment(NULL), dnaObj(NULL) {}
    DNAFragment(Annotation* fragment, DNASequenceObject* sObj, const QList<AnnotationTableObject*> relatedAnns);
    bool isEmpty() const { return annotatedFragment == NULL || dnaObj == NULL; }
    QString getName() const;
    QString getSequenceName() const;
    QString getSequenceDocName() const;
    QList<LRegion> getFragmentRegions() const; 
    QByteArray getSequence() const;
    int getLength() const;
    DNAAlphabet* getAlphabet() const;
    const QByteArray& getSourceSequence() const; 
    QString getLeftTerminus() const;
    QString getRightTerminus() const;
    QString getLeftOverhang() const;
    QString getRightOverhang() const;
    QString getLeftTermType() const;
    QString getRightTermType() const;

    void setRightTermType( const QString& termType );
    void setLeftTermType( const QString& termType );
    void setLeftOverhang( const QString& overhang );
    void setRightOverhang( const QString& overhang );

    const QList<AnnotationTableObject*>& getRelatedAnnotations() const { return relatedAnnotations; }
    
    static QList<DNAFragment> findAvailableFragments();
    static QList<DNAFragment> findAvailableFragments(const QList<GObject*>& aObjects, const QList<GObject*>& sObjects);
   
};



} //namespace

#endif // _U2_DNA_FRAGMENT_H_
