/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DIGEST_SEQUENCE_DIALOG_H_
#define _U2_DIGEST_SEQUENCE_DIALOG_H_

#include <U2Core/LRegion.h>
#include <U2Gui/MainWindow.h>

#include <ui/ui_DigestSequenceDialog.h>

#include "EnzymeModel.h"
#include "EnzymesQuery.h"

#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

namespace U2 {

class ADVSequenceObjectContext;
class DNASequenceObject;
class CreateAnnotationWidgetController;

class DigestSequenceDialog : public QDialog, public Ui_DigestSequenceDialog {
    Q_OBJECT
public:
    DigestSequenceDialog(ADVSequenceObjectContext* ctx, QWidget* parent);
    virtual void accept();

private slots:
    void sl_addPushButtonClicked();
    void sl_addAllPushButtonClicked();
    void sl_removePushButtonClicked();
    void sl_clearPushButtonClicked();
    void sl_searchSettingsPushButtonClicked();
    void sl_useAnnotatedRegionsSelected(bool toggle);
    
private:
    void addAnnotationWidget();
    void searchForAnnotatedEnzymes();
    void updateAvailableEnzymeWidget();
    void updateSelectedEnzymeWidget();
    bool loadEnzymesFile();
    QList<SEnzymeData> findEnzymeDataById(const QString& id);
    
    ADVSequenceObjectContext*           seqCtx;
    DNASequenceObject*                  dnaObj;
    EnzymesSelectorDialogHandler        enzymesSelectorHandler;
    CreateAnnotationWidgetController*   ac;
    QSet<QString>                       availableEnzymes;
    QSet<QString>                       selectedEnzymes;
    QMap<QString,LRegion>               annotatedEnzymes;
    QList<SEnzymeData>                  enzymesBase;
    
};


} //namespace

#endif
