/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_EDIT_FRAGMENT_DIALOG_H_
#define _U2_EDIT_FRAGMENT_DIALOG_H_

#include "DNAFragment.h"

#include <ui/ui_EditFragmentDialog.h>

namespace U2 {

class DNATranslation;

class EditFragmentDialog : public QDialog, public Ui_EditFragmentDialog {
    Q_OBJECT
public:
   EditFragmentDialog(const DNAFragment& fragment, QWidget* p);
   virtual void accept();
private:
   DNAFragment dnaFragment;
   DNATranslation* transl;
   QString seq,trseq;
   void updatePreview();
   void resetLeftOverhang();
   void resetRightOverhang();
   bool isValidOverhang(const QString& text);
private slots:
   void sl_updatePreview();
   void sl_onLeftResetClicked();
   void sl_onRightResetClicked();
   void sl_customOverhangSet(const QString& text);

};


} //namespace

#endif
