/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ENZYME_MODEL_H_
#define _U2_ENZYME_MODEL_H_

#include <QtCore/QSharedData>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QString>
#include <QtCore/QByteArray>

namespace U2 {

#define ULOG_ENZYME_PLUGIN QString("Plugin: Enzymes")

class DNAAlphabet;

#define QUALIFIER_SPLIT                 "SPLIT"
#define QUALIFIER_LEFT_TERM             "5'term"
#define QUALIFIER_LEFT_OVERHANG         "5'overhang"
#define QUALIFIER_LEFT_TYPE             "5'type"
#define QUALIFIER_RIGHT_TERM            "3'term"
#define QUALIFIER_RIGHT_OVERHANG        "3'overhang"
#define QUALIFIER_RIGHT_TYPE            "3'type"
#define QUALIFIER_SPLIT_TERM            "split_term"
#define QUALIFIER_SPLIT_OVERHANG        "split_overhang"
#define QUALIFIER_SPLIT_TYPE            "split_type"
#define QUALIFIER_SOURCE                "fragment_source"
#define OVERHANG_TYPE_BLUNT             "blunt"
#define OVERHANG_TYPE_STICKY            "sticky"
#define ANNOTATION_GROUP_FRAGMENTS      "Fragments"
#define ANNOTATION_GROUP_ENZYME         "enzyme"

#define ENZYME_CUT_UNKNOWN 0x7FFFFF

class EnzymeData: public QSharedData {
public:
    inline EnzymeData();

    QString         id;
    QString         accession;
    QString         type;
    QByteArray      seq;
    int             cutDirect; //starts from the first char in direct strand
    int             cutComplement; // starts from the first char in complement strand, negative->right offset
    QString         organizm;
    DNAAlphabet*    alphabet;
};

EnzymeData::EnzymeData() {
    cutDirect = ENZYME_CUT_UNKNOWN;
    cutComplement = ENZYME_CUT_UNKNOWN;
    alphabet = NULL;
}

typedef QSharedDataPointer<EnzymeData> SEnzymeData;

} //namespace

#endif
