/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ENZYMES_PLUGIN_H_
#define _U2_ENZYMES_PLUGIN_H_

#include <U2Core/PluginModel.h>
#include <U2Gui/ObjectViewModel.h>

namespace U2 {

class EnzymesADVContext;

class EnzymesPlugin : public Plugin  {
    Q_OBJECT
public:
    EnzymesPlugin();
    ~EnzymesPlugin();
    void createToolsMenu();
private slots:
    void sl_onOpenDigestSequenceDialog();
    void sl_onOpenConstructMoleculeDialog();
private:
    EnzymesADVContext*  ctxADV;
    QAction* openDigestSequenceDialog;
    QAction* openConstructMoleculeDialog;
};

class EnzymesADVContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    EnzymesADVContext(QObject* p, const QList<QAction*>& cloningActions);

protected slots:
    void sl_search();

protected:
    virtual void buildMenu(GObjectView* v, QMenu* m);
    virtual void initViewContext(GObjectView* view);
    QList<QAction*> cloningActions;
};

} //namespace

#endif
