/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_EXTERNAL_TOOL_RUN_TASK_H
#define _U2_EXTERNAL_TOOL_RUN_TASK_H

#include <U2Core/Task.h>
#include <QtCore/QProcess>

namespace U2 {

class ExternalToolLogParser;
class ExternalToolRunTask: public Task {
    Q_OBJECT
public:
    ExternalToolRunTask(const QString& toolName, const QStringList& arguments, ExternalToolLogParser*  logParser);
    ~ExternalToolRunTask();

    void prepare();
    void run();
    Task::ReportResult report();

    void cancelProcess();
public slots:
    void sl_onReadyToReadLog();
    void sl_onReadyToReadErrLog();
private:
    QStringList             arguments;
    QString                 program;
    QProcess*               externalToolProcess;
    ExternalToolLogParser*  logParser;
    char*                   logData;
    QString                 toolName;
};

class ExternalToolLogParser {
public:
    ExternalToolLogParser();
    virtual int getProgress(){ return progress; }
    virtual void parseOutput(const QString& partOfLog);
    virtual void parseErrOutput(const QString& partOfLog);
private:
    /* Percent values in range 0..100, negative if unknown. */
    int         progress;
    QString     lastLine;
    QString     lastErrLine;
protected:
    QStringList lastPartOfLog;
};

}//namespace

#endif // _U2_EXTERNAL_TOOL_RUN_TASK_H
