/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _ETS_TASK_LOCAL_STORAGE_
#define _ETS_TASK_LOCAL_STORAGE_

#include <QtCore/QThreadStorage>

class ETSContext;

namespace U2 {

class ETSContextTLSRef {
public:
    ETSContextTLSRef(ETSContext* _ctx, int _workerID) : ctx(_ctx), workerID(_workerID){}
    ETSContext* ctx;
    int workerID;
};

class TaskLocalData {
public:
    static ETSContext* current();

    static unsigned currentWorkerID();


    static void bindToETSTLSContext(ETSContext *ctx, int workerID = 0);

    static void detachETSTLSContext();


private:
    static QThreadStorage<ETSContextTLSRef*> tls;
};
} //namespace

#endif
