/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_BLASTPLUS_SUPPORT_H
#define _U2_BLASTPLUS_SUPPORT_H

#include <U2Core/ExternalToolRegistry.h>
#include <U2Gui/ObjectViewModel.h>

#define BLASTN_TOOL_NAME "BlastN"
#define BLASTP_TOOL_NAME "BlastP"
#define BLASTX_TOOL_NAME "BlastX"
#define TBLASTN_TOOL_NAME "TBlastN"
#define TBLASTX_TOOL_NAME "TBlastX"
namespace U2 {

class BlastPlusSupport : public ExternalTool {
    Q_OBJECT
public:
    BlastPlusSupport(const QString& name, const QString& path = "");
public slots:
    void sl_runWithExtFileSpecify();
private:
    QString lastDBPath;
    QString lastDBName;
};

class BlastPlusSupportContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    BlastPlusSupportContext(QObject* p);

protected slots:
    void sl_showDialog();

protected:
    virtual void initViewContext(GObjectView* view);
    virtual void buildMenu(GObjectView* view, QMenu* m);
private:
    QStringList toolList;
    QString lastDBPath;
    QString lastDBName;
};

}//namespace
#endif // _U2_BLASTPLUS_SUPPORT_H
