/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REPEAT_QUERY_H_
#define _U2_REPEAT_QUERY_H_

#include "FindRepeatsTask.h"

#include "U2Lang/QDScheme.h"
#include <U2Lang/QueryDesignerRegistry.h>


namespace U2 {

class QDRepeatActor : public QDActor {
    Q_OBJECT
public:
    int getMinResultLen() const;
    int getMaxResultLen() const;
    QString getText() const;
    Task* getAlgorithmTask(const QList<LRegion>& location);
    QList< QPair<QString,QString> > saveConfiguration() const;
    void loadConfiguration(const QList< QPair<QString,QString> >& strMap);
    QColor defaultColor() const { return QColor(0x66,0xa3,0xd2); }
protected:
    QDRepeatActor(QDActorPrototype const* proto);
    friend class QDRepeatActorPrototype;
private slots:
    void sl_onAlgorithmTaskFinished();
private:
    FindRepeatsTaskSettings settings;
    QList<FindRepeatsToAnnotationsTask*> repTasks;
};

class QDRepeatActorPrototype : public QDActorPrototype {
public:
    QDRepeatActorPrototype();
    QIcon getIcon() const { return QIcon(":repeat_finder/images/repeats.png"); }
    QDActor* createInstance() const { return new QDRepeatActor(this); }
};

}//namespace

#endif
