/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REMOTE_DB_FETCHER_H_
#define _U2_REMOTE_DB_FETCHER_H_

#include <U2Lang/LocalDomain.h>
#include <U2Lang/WorkflowUtils.h>

namespace U2 {
namespace LocalWorkflow {

class RemoteDBFetcherPrompter : public PrompterBase<RemoteDBFetcherPrompter>
{
    Q_OBJECT

public:
    RemoteDBFetcherPrompter(Actor *p = 0) : PrompterBase<RemoteDBFetcherPrompter>(p) {}

protected:
    virtual QString composeRichDoc();
};

class RemoteDBFetcherWorker : public BaseWorker
{
    Q_OBJECT

public:
    RemoteDBFetcherWorker (Actor *a);

    virtual void init();
    virtual bool isReady();
    virtual Task* tick();
    virtual bool isDone();
    virtual void cleanup();

private slots:
    void sl_taskFinished();

protected:
    CommunicationChannel *output;

    QString dbid;
    QString fullPathDir;
    QStringList seqids;
};

class RemoteDBFetcherFactory : public DomainFactory
{
public:
    static const QString ACTOR_ID;

public:
    RemoteDBFetcherFactory() : DomainFactory(ACTOR_ID) {}

    static void init();
    virtual Worker* createWorker(Actor *a) { return new RemoteDBFetcherWorker(a); }
};

}   // namespace U2
}   // namespace LocalWorkflow

#endif  // #ifndef _U2_REMOTE_DB_FETCHER_H_
