/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_KALIGN_TASK_H_
#define _U2_KALIGN_TASK_H_

#include <U2Core/Task.h>
#include <U2Core/MAlignmentObject.h>
#include <U2Core/SaveDocumentTask.h>
#include <U2Algorithm/MSAAlignTask.h>
#include <U2Core/TLSTask.h>
#include <QtCore/QPointer>

#define KALIGN_CONTEXT_ID "kalign"

struct kalign_context;

namespace U2 {

class StateLock;
class MAlignmentObject;
class LoadDocumentTask;

class KalignContext : public TLSContext {
public:
    KalignContext(kalign_context* _d) : TLSContext(KALIGN_CONTEXT_ID), d(_d) { }
    kalign_context* d;
};

class KalignTaskSettings {
public:
    KalignTaskSettings() {reset();}
    void reset();

        float   gapOpenPenalty;
        float   gapExtenstionPenalty;
        float   termGapPenalty;
        float   secret;
        QString inputFilePath;
    //used only for KalignTaskOp_DoAlign
    //bool            alignRegion;
    //LRegion         regionToAlign;
};

class KalignTask : public TLSTask {
    Q_OBJECT
public:
    KalignTask(const MAlignment& ma, const KalignTaskSettings& config);
    
    void _run();
    void doAlign();
    ReportResult report();

    KalignTaskSettings          config;
    MAlignment                  inputMA;
    MAlignment                  resultMA;

    MAlignment                  inputSubMA;
    MAlignment                  resultSubMA;
protected:
    TLSContext* createContextInstance();
};

//locks MAlignment object and propagate KalignTask results to it
class  KalignGObjectTask : public Task {
    Q_OBJECT
public:
    KalignGObjectTask(MAlignmentObject* obj, const KalignTaskSettings& config);
    ~KalignGObjectTask();     

    virtual void prepare();
    ReportResult report();

    QPointer<MAlignmentObject>  obj;
    StateLock*                  lock;
    KalignTask*                 kalignTask;
    KalignTaskSettings          config;
};

class KalignWithExtFileSpecifySupportTask : public Task {
public:
    KalignWithExtFileSpecifySupportTask(const KalignTaskSettings& config);
    void prepare();
    Task::ReportResult report();    

    QList<Task*> onSubTaskFinished(Task* subTask);
private:
    MAlignmentObject*   mAObject;
    Document*           currentDocument;

    SaveDocumentTask*   saveDocumentTask;
    LoadDocumentTask*   loadDocumentTask;
    KalignGObjectTask*  kalignGObjectTask;
    KalignTaskSettings  config;
};

class KalignMainTask : public MSAAlignTask {
    Q_OBJECT
    MSA_ALIGN_TASK_FACTORY(KalignMainTask)
public:
    static const QString OPTION_GAP_OPEN_PENALTY; 
    static const QString OPTION_GAP_EXTENSION_PENALTY;
    static const QString OPTION_TERMINAL_GAP_PENALTY; 
    static const QString OPTION_BONUS_SCORE;

    KalignMainTask(MAlignmentObject* obj, const MSAAlignTaskSettings & config);
};

}//namespace

#endif
