/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "muscle.h"
#include "msa.h"

void OutWeights(const char *FileName, const MSA &msa)
	{
	FILE *f = fopen(FileName, "w");
	if (0 == f)
		Quit("Cannot open '%s'", FileName);
	const unsigned uSeqCount = msa.GetSeqCount();
	for (unsigned uSeqIndex = 0; uSeqIndex < uSeqCount; ++uSeqIndex)
		{
		const char *Id = msa.GetSeqName(uSeqIndex);
		const WEIGHT w = msa.GetSeqWeight(uSeqIndex);
		fprintf(f, "%s\t%.3g\n", Id, w);
		}
	fclose(f);
	}
