/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_MWTOOLBAR_IMPL_H_
#define _U2_MWTOOLBAR_IMPL_H_

#include <U2Gui/MainWindow.h>

#include <QtGui/QToolBar>
#include <QtGui/QMainWindow>

namespace U2 {

class MWToolBarManagerImpl : public MWToolBarManager {
public:	
	MWToolBarManagerImpl(QMainWindow* mw);
	~MWToolBarManagerImpl();

	virtual QToolBar* getToolbar(const QString& sysName) const;

protected:
	bool eventFilter(QObject *obj, QEvent *event);

private:
	QToolBar* createToolBar(const QString& sysName);
	void updateToolbarVisibilty();

	QMainWindow*		mw;
	QList<QToolBar*>	toolbars;
};

}//namespace

#endif
