/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

// UgDataset		collection of all UgDataList-based instance
// UgDatasetPair	UgDataClass and UgDataList pair for UgDataset
//
// UgData
// |
// `- UgDataset

#ifndef UG_DATASET_H
#define UG_DATASET_H

#include <glib.h>
#include <ug_data.h>

#ifdef __cplusplus
extern "C" {
#endif

// These macro is for internal use only.
// use ug_dataset_get(dataset, UgDataCommonClass, 0) to instead UG_DATASET_COMMON(dataset)
#define	UG_DATASET_COMMON(dataset)			( (UgDataCommon*)((dataset)->pair[0].value) )
#define	UG_DATASET_PROXY(dataset)			( (UgDataProxy*) ((dataset)->pair[1].value) )
#define	UG_DATASET_PROGRESS(dataset)		( (UgProgress*)  ((dataset)->pair[2].value) )
#define	UG_DATASET_RELATION(dataset)		( (UgRelation*)  ((dataset)->pair[3].value) )
#define	UG_DATASET_RELATION_CLASS(dataset)	( (dataset)->pair[3].key )

typedef struct	UgDataset_			UgDataset;		// collection of all UgDataList-based instance
typedef struct	UgDatasetPair_		UgDatasetPair;	// UgDataClass and UgDataList pair

// GDestroyNotify
typedef void	(*UgDestroyFunc)	(gpointer destroy_data);

//extern	const	UgDataClass*	UgDatasetClass;

// ----------------------------------------------
// UgDatasetPair : a pair for UgDataClass and it's instance.
struct UgDatasetPair_
{
	const UgDataClass*	key;
	UgDataList*			value;
};

// ----------------------------------------------------------------------------
// UgDataset : collection of all UgDataList-based instance.
//             It also contain iterator for UgCategory.
//
struct UgDataset_
{
	UG_DATA_MEMBERS;
//	const UgDataClass*	data_class;		// for UgMarkup input/output

	guint			ref_count;

	// protected --------------------------------
//	struct Protected {
	UgDatasetPair*	pair;
	guint			pair_len;
	guint			pair_alloc_len;
//	} protected;

	// public, but can't copy -------------------
	// call user.destroy(user.data) when a dataset instance is destroying
	struct {
		UgDestroyFunc	destroy;
		gpointer		data;
		gpointer		pointer;
	} user;
};

UgDataset*	ug_dataset_new   (void);
void		ug_dataset_ref   (UgDataset* dataset);
void		ug_dataset_unref (UgDataset* dataset);

// Gets the element at the given position in a list.
gpointer	ug_dataset_get (UgDataset* dataset, const UgDataClass* data_class, guint nth);

// Removes the element at the given position in a list.
void		ug_dataset_remove (UgDataset* dataset, const UgDataClass* data_class, guint nth);

// If nth instance of data_class exist, return nth instance.
// If nth instance of data_class not exist, alloc new instance in tail and return it.
gpointer	ug_dataset_realloc (UgDataset* dataset, const UgDataClass* data_class, guint nth);

gpointer	ug_dataset_alloc_front (UgDataset* dataset, const UgDataClass* data_class);
gpointer	ug_dataset_alloc_back  (UgDataset* dataset, const UgDataClass* data_class);

// ------------------------------------
// UgDataset list functions
guint			ug_dataset_list_length (UgDataset* dataset, const UgDataClass* data_class);

UgDataList**	ug_dataset_alloc_list (UgDataset* dataset, const UgDataClass* data_class);

UgDataList**	ug_dataset_get_list (UgDataset* dataset, const UgDataClass* data_class);

// free old list in dataset and set list with new_list.
void			ug_dataset_set_list (UgDataset* dataset, const UgDataClass* data_class, gpointer new_list);

// Cuts the element at the given position in a list.
//UgDataList*	ug_dataset_cut_list (UgDataset* dataset, const UgDataClass* data_class, guint nth);
gpointer		ug_dataset_cut_list (UgDataset* dataset, const UgDataClass* data_class, guint nth);


#ifdef __cplusplus
}
#endif

#endif  // UG_DATASET_H

