/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_IPC_H
#define UG_IPC_H

#include <glib.h>

#define UGET_SOCKET_PORT		14777
#define UGET_SOCKET_PORT_S		"14777"
#define UGET_SOCKET_NAME		"UgetIPC"
#define UGET_SOCKET_HEADER_S	"UG"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct	UgIpc_			UgIpc;
typedef enum	UgIpcCode_		UgIpcCode;

struct UgIpc_
{
	GIOChannel*		channel;
	gboolean		server_inited;

	// server queue
	GQueue			queue;
	guint			queue_limit;

	// UNIX
	gchar*			file;
};

enum UgIpcCode_
{
	UG_IPC_ERROR,
	UG_IPC_OK,
	UG_IPC_BUSY,
	UG_IPC_PING,
	UG_IPC_SEND,
};

void	ug_ipc_init (UgIpc* ipc, const gchar* socket_file);
void	ug_ipc_finalize (UgIpc* ipc);

// client or server
gboolean	ug_ipc_server_start   (UgIpc* ipc);
gboolean	ug_ipc_client_connect (UgIpc* ipc);

// use with ug_ipc_client_connect()
// client functions, ping server or send arguments to server.
gboolean	ug_ipc_ping (UgIpc* ipc);
gboolean	ug_ipc_send (UgIpc* ipc, int argc, char** argv);

// use with ug_ipc_server_start()
// server functions, get arguments from queue.
GPtrArray*	ug_ipc_peek (UgIpc* ipc);
GPtrArray*	ug_ipc_pop  (UgIpc* ipc);

// ------------------------------------
// argument functions, free or copy GPtrArray from ug_ipc_peek() and ug_ipc_pop()
GPtrArray*	ug_arg_new  (int argc, char** argv, gboolean copy_strings);
void		ug_arg_free (GPtrArray* args, gboolean free_strings);
GPtrArray*	ug_arg_copy (GPtrArray* args, gboolean copy_strings);


#endif	// UG_IPC_H

