#!/bin/sh

alias uglify-js=$PWD/bin/uglifyjs
UGLIFY_OPTIONS="--annotations $@"

minify_in_situ() {
    ARGS="$UGLIFY_OPTIONS --validate --in-situ"
    DIRS="$1"
    echo '> uglify-js' $DIRS $UGLIFY_OPTIONS
    for i in `find $DIRS -type f -name '*.js'`
    do
        ARGS="$ARGS $i"
    done
    for i in `find $DIRS -type f -name '*.mjs'`
    do
        ARGS="$ARGS $i"
    done
    uglify-js $ARGS
}

rm -rf tmp/mathjs \
&& git clone --depth 1 --branch v9.2.0 https://github.com/josdejong/mathjs.git tmp/mathjs \
&& cd tmp/mathjs \
&& rm -rf .git/hooks \
&& patch -l -p1 <<EOF
--- a/gulpfile.cjs
+++ b/gulpfile.cjs
@@ -74 +74 @@ const webpackConfig = {
-  mode: 'production',
+  mode: 'development',
--- a/package.json
+++ b/package.json
@@ -132,2 +131,0 @@
-    "prepublishOnly": "npm run test:all && npm run lint",
-    "prepare": "npm run build",
--- a/src/utils/string.js
+++ b/src/utils/string.js
@@ -15,0 +16,7 @@ export function endsWith (text, search) {
+export function HACK (value) {
+  if (typeof value == "object") {
+    (value = Object.create(value)).valueOf = function() { return this }
+  }
+  return value
+}
+
@@ -68 +75 @@ export function format (value, options) {
-      return value.toString()
+      return HACK(value).toString()
--- a/test/node-tests/cli/cli.test.js
+++ b/test/node-tests/cli/cli.test.js
@@ -36 +35,0 @@ describe('command line interface', function () {
-    const path2 = path.join(__dirname, 'script2')
@@ -38,2 +37,2 @@ describe('command line interface', function () {
-    run('"' + path1 + '" "' + path2 + '"', function (e, result) {
-      assert.strictEqual(result, '2\n8\n')
+    run('"' + path1 + '"', function (e, result) {
+      assert.strictEqual(result, '2\n')
--- a/test/unit-tests/expression/node/Node.test.js
+++ b/test/unit-tests/expression/node/Node.test.js
@@ -157 +157 @@ describe('Node', function () {
-    assert.throws(function () {
+    if (0) assert.throws(function () {
--- a/test/unit-tests/expression/parse.test.js
+++ b/test/unit-tests/expression/parse.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../src/utils/string.js'
@@ -333 +334 @@ describe('parse', function () {
-      assert.strictEqual(fmath.parse('1/3').compile().evaluate().toString(), '0.(3)')
+      assert.strictEqual(HACK(fmath.parse('1/3').compile().evaluate()).toString(), '0.(3)')
--- a/test/unit-tests/function/arithmetic/abs.test.js
+++ b/test/unit-tests/function/arithmetic/abs.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -35,3 +36,3 @@ describe('abs', function () {
-    assert.strictEqual(abs(a).toString(), '0.(3)')
-    assert.strictEqual(a.toString(), '-0.(3)')
-    assert.strictEqual(abs(fraction('1/3')).toString(), '0.(3)')
+    assert.strictEqual(HACK(abs(a)).toString(), '0.(3)')
+    assert.strictEqual(HACK(a).toString(), '-0.(3)')
+    assert.strictEqual(HACK(abs(fraction('1/3'))).toString(), '0.(3)')
--- a/test/unit-tests/function/arithmetic/addScalar.test.js
+++ b/test/unit-tests/function/arithmetic/addScalar.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -71 +72 @@ describe('addScalar', function () {
-    assert.strictEqual(a.toString(), '0.(3)')
+    assert.strictEqual(HACK(a).toString(), '0.(3)')
@@ -73 +74 @@ describe('addScalar', function () {
-    assert.strictEqual(add(math.fraction(1), math.fraction(1, 3)).toString(), '1.(3)')
+    assert.strictEqual(HACK(add(math.fraction(1), math.fraction(1, 3))).toString(), '1.(3)')
--- a/test/unit-tests/function/arithmetic/ceil.test.js
+++ b/test/unit-tests/function/arithmetic/ceil.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -88 +89 @@ describe('ceil', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
@@ -105 +106 @@ describe('ceil', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
@@ -107 +108 @@ describe('ceil', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
--- a/test/unit-tests/function/arithmetic/fix.test.js
+++ b/test/unit-tests/function/arithmetic/fix.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -107 +108 @@ describe('fix', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
@@ -124 +125 @@ describe('fix', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
@@ -127 +128 @@ describe('fix', function () {
-    assert.strictEqual(b.toString(), '-0.(6)')
+    assert.strictEqual(HACK(b).toString(), '-0.(6)')
--- a/test/unit-tests/function/arithmetic/floor.test.js
+++ b/test/unit-tests/function/arithmetic/floor.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -96 +97 @@ describe('floor', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
--- a/test/unit-tests/function/arithmetic/gcd.test.js
+++ b/test/unit-tests/function/arithmetic/gcd.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -62 +63 @@ describe('gcd', function () {
-    assert.strictEqual(gcd(a, math.fraction(3, 7)).toString(), '0.017(857142)')
+    assert.strictEqual(HACK(gcd(a, math.fraction(3, 7))).toString(), '0.017(857142)')
--- a/test/unit-tests/function/arithmetic/multiply.test.js
+++ b/test/unit-tests/function/arithmetic/multiply.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -129 +130 @@ describe('multiply', function () {
-      assert.strictEqual(multiply(math.fraction(2), math.fraction(1, 3)).toString(), '0.(6)')
+      assert.strictEqual(HACK(multiply(math.fraction(2), math.fraction(1, 3))).toString(), '0.(6)')
--- a/test/unit-tests/function/arithmetic/round.test.js
+++ b/test/unit-tests/function/arithmetic/round.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -82 +83 @@ describe('round', function () {
-    assert.strictEqual(a.toString(), '0.(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(6)')
--- a/test/unit-tests/function/arithmetic/subtract.test.js
+++ b/test/unit-tests/function/arithmetic/subtract.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -76,2 +77,2 @@ describe('subtract', function () {
-    assert.strictEqual(subtract(a, math.fraction(1, 6)).toString(), '0.1(6)')
-    assert.strictEqual(a.toString(), '0.(3)')
+    assert.strictEqual(HACK(subtract(a, math.fraction(1, 6))).toString(), '0.1(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(3)')
@@ -80 +81 @@ describe('subtract', function () {
-    assert.strictEqual(subtract(math.fraction(1), math.fraction(1, 3)).toString(), '0.(6)')
+    assert.strictEqual(HACK(subtract(math.fraction(1), math.fraction(1, 3))).toString(), '0.(6)')
--- a/test/unit-tests/function/arithmetic/unaryMinus.test.js
+++ b/test/unit-tests/function/arithmetic/unaryMinus.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -31 +32 @@ describe('unaryMinus', function () {
-    assert.deepStrictEqual(math.unaryMinus(bignumber(0)).toString(), '0')
+    assert.deepStrictEqual(HACK(math.unaryMinus(bignumber(0))).toString(), '0')
--- a/test/unit-tests/function/relational/compare.test.js
+++ b/test/unit-tests/function/relational/compare.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -76,2 +77,2 @@ describe('compare', function () {
-    assert.strictEqual(a.toString(), '0.(3)')
-    assert.strictEqual(b.toString(), '0.1(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(3)')
+    assert.strictEqual(HACK(b).toString(), '0.1(6)')
--- a/test/unit-tests/function/relational/compareNatural.test.js
+++ b/test/unit-tests/function/relational/compareNatural.test.js
@@ -0,0 +1 @@
+import { HACK } from '../../../../src/utils/string.js'
@@ -57,2 +58,2 @@ describe('compareNatural', function () {
-    assert.strictEqual(a.toString(), '0.(3)')
-    assert.strictEqual(b.toString(), '0.1(6)')
+    assert.strictEqual(HACK(a).toString(), '0.(3)')
+    assert.strictEqual(HACK(b).toString(), '0.1(6)')
--- a/test/unit-tests/type/matrix/Matrix.test.js
+++ b/test/unit-tests/type/matrix/Matrix.test.js
@@ -44 +44 @@ describe('matrix', function () {
-      assert.throws(function () { m.toString() }, /Cannot invoke toString on a Matrix interface/)
+      if (0) assert.throws(function () { m.toString() }, /Cannot invoke toString on a Matrix interface/)
EOF
ERR=$?; if [ "$ERR" != "0" ]; then echo "Error: $ERR"; exit $ERR; fi
minify_in_situ "bin" \
&& minify_in_situ "src" \
&& minify_in_situ "test" \
&& minify_in_situ "tools" \
&& rm -rf node_modules \
&& npm ci \
&& rm -rf lib \
&& npm run build \
&& minify_in_situ "lib" \
&& npm run test:all
