/*

  Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
*/

/* Locale dependent routines */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "ximserver.h"
#ifndef __GNUC__
# ifdef HAVE_ALLOCA_H
#  include <alloca.h>
# endif
#endif

static char *
ustring_to_euc_str(uString *s)
{
    uString::iterator i;
    int l=0;
    char *c;
    /* count the length*/
    for (i = s->begin(); i!= s->end(); i++) {
        l++;
        if (*i > 256) {
            l ++;
        }
    }
    c = (char *)malloc(l+1);
    c[l] = 0;
    l = 0;
    for (i = s->begin() ; i!= s->end(); i++) {
        if (*i < 256) {
            c[l] = *i;
            l++;
        } else {
            c[l] = ((*i)>>8)|0x80;
            c[l+1] = ((*i)&0xff)|0x80;
            l+=2;
        }
    }
    return c;
}

char *
Locale::uStringToCtext(uString *us)
{
    char *str = ustring_to_euc_str(us);
    XTextProperty prop;
    XmbTextListToTextProperty(XimServer::gDpy, &str, 1,
			      XCompoundTextStyle, &prop);
    free(str);
    char *res = strdup((char *)prop.value);
    XFree(prop.value);
    return res;
}

bool
Locale::supportOverTheSpot()
{
  return false;
}

class EUCJP_Locale : public Locale {
public:
  virtual char *uStringToCtext(uString *us) {
    int len;
    char *t;
    len = us->size() * 10;
    t = (char *)alloca(len+1);
    uString::iterator i;
    bool jp_mode=false;
    int cur,j=0;

    for (i = us->begin(); i != us->end(); i++) {
        cur = *i;
        if (!(cur & 0xff00)) {
            if (jp_mode) {
                t[j++] = 0x1b;
                t[j++] = 0x28;
                t[j++] = 0x42;
                jp_mode = false;
            }
            t[j++] = cur & 0xff;
        } else {
            if (!jp_mode) {
                jp_mode = true;
                t[j++] = 0x1b;
                t[j++] = 0x24;
                t[j++] = 0x29;
                t[j++] = 0x42;
            }
            t[j++] = (cur >> 8)|0x80;
            t[j++] = (cur & 0xff)|0x80;
        }
    }
    if (jp_mode) {
      t[j++] = 0x1b;
      t[j++] = 0x28;
      t[j++] = 0x42;
    }
    t[j] = 0;
    return strdup(t);
  };
  virtual bool supportOverTheSpot() {
    return true;
  }
};

Locale *getLocale(char *lang)
{
  if (!strcmp(lang, "ja")) {
    return new EUCJP_Locale();
  }
  return NULL;
}
