;;;
;;; Copyright (c) 2003-2005 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;; Charset of this file is UTF-8

(require "generic.scm")

(define latin-compose-rule '(
((("\\" " " " " ))(" "))
((("\\" " " "'" ))("'"))
((("\\" " " "(" ))("˘"))
((("\\" " " "-" ))("~"))
((("\\" " " "<" ))("ˇ"))
((("\\" " " ">" ))("^"))
((("\\" " " "^" ))("^"))
((("\\" " " "`" ))("`"))
((("\\" " " "~" ))("~"))
((("\\" "!" "!" ))("¡"))
((("\\" "!" "P" ))("¶"))
((("\\" "!" "S" ))("§"))
((("\\" "!" "p" ))("¶"))
((("\\" "!" "s" ))("§"))
((("\\" "\"" "\"" ))("¨"))
((("\\" "\"" "A" ))("Ä"))
((("\\" "\"" "E" ))("Ë"))
((("\\" "\"" "I" ))("Ï"))
((("\\" "\"" "O" ))("Ö"))
((("\\" "\"" "U" ))("Ü"))
((("\\" "\"" "Y" ))("Ÿ"))
((("\\" "\"" "a" ))("ä"))
((("\\" "\"" "e" ))("ë"))
((("\\" "\"" "i" ))("ï"))
((("\\" "\"" "o" ))("ö"))
((("\\" "\"" "u" ))("ü"))
((("\\" "\"" "y" ))("ÿ"))
((("\\" "'" " " ))("'"))
((("\\" "'" "'" ))("´"))
((("\\" "'" "A" ))("Á"))
((("\\" "'" "C" ))("Ć"))
((("\\" "'" "E" ))("É"))
((("\\" "'" "I" ))("Í"))
((("\\" "'" "L" ))("Ĺ"))
((("\\" "'" "N" ))("Ń"))
((("\\" "'" "O" ))("Ó"))
((("\\" "'" "R" ))("Ŕ"))
((("\\" "'" "S" ))("Ś"))
((("\\" "'" "U" ))("Ú"))
((("\\" "'" "Y" ))("Ý"))
((("\\" "'" "Z" ))("Ź"))
((("\\" "'" "a" ))("á"))
((("\\" "'" "c" ))("ć"))
((("\\" "'" "e" ))("é"))
((("\\" "'" "i" ))("í"))
((("\\" "'" "l" ))("ĺ"))
((("\\" "'" "n" ))("ń"))
((("\\" "'" "o" ))("ó"))
((("\\" "'" "r" ))("ŕ"))
((("\\" "'" "s" ))("ś"))
((("\\" "'" "u" ))("ú"))
((("\\" "'" "y" ))("ý"))
((("\\" "'" "z" ))("ź"))
((("\\" "(" " " ))("˘"))
((("\\" "(" "(" ))("["))
((("\\" "(" "-" ))("{"))
((("\\" "(" "A" ))("Ă"))
((("\\" "(" "G" ))("Ğ"))
((("\\" "(" "c" ))("©"))
((("\\" "(" "a" ))("ă"))
((("\\" "(" "g" ))("ğ"))
((("\\" "(" "r" ))("®"))
((("\\" ")" ")" ))("]"))
((("\\" ")" "-" ))("}"))
((("\\" "*" "0" ))("°"))
((("\\" "*" "A" ))("Å"))
((("\\" "*" "U" ))("Ů"))
((("\\" "*" "a" ))("å"))
((("\\" "*" "u" ))("ů"))
((("\\" "+" "+" ))("#"))
((("\\" "+" "-" ))("±"))
((("\\" "," "," ))("¸"))
((("\\" "," "-" ))("¬"))
((("\\" "," "A" ))("Ą"))
((("\\" "," "C" ))("Ç"))
((("\\" "," "E" ))("Ę"))
((("\\" "," "G" ))("Ģ"))
((("\\" "," "I" ))("Į"))
((("\\" "," "K" ))("Ķ"))
((("\\" "," "L" ))("Ļ"))
((("\\" "," "N" ))("Ņ"))
((("\\" "," "R" ))("Ŗ"))
((("\\" "," "S" ))("Ş"))
((("\\" "," "U" ))("Ų"))
((("\\" "," "a" ))("ą"))
((("\\" "," "c" ))("ç"))
((("\\" "," "e" ))("ę"))
((("\\" "," "g" ))("ģ"))
((("\\" "," "i" ))("į"))
((("\\" "," "k" ))("ķ"))
((("\\" "," "l" ))("ļ"))
((("\\" "," "n" ))("ņ"))
((("\\" "," "r" ))("ŗ"))
((("\\" "," "s" ))("ş"))
((("\\" "," "u" ))("ų"))
((("\\" "-" " " ))("~"))
((("\\" "-" "(" ))("{"))
((("\\" "-" ")" ))("}"))
((("\\" "-" "+" ))("±"))
((("\\" "-" "," ))("¬"))
((("\\" "-" "-" ))("­"))
((("\\" "-" ":" ))("÷"))
((("\\" "-" "A" ))("Ã"))
((("\\" "-" "D" ))("Đ"))
((("\\" "-" "E" ))("Ē"))
((("\\" "-" "I" ))("Ī"))
((("\\" "-" "L" ))("£"))
((("\\" "-" "N" ))("Ñ"))
((("\\" "-" "O" ))("Õ"))
((("\\" "-" "U" ))("Ū"))
((("\\" "-" "Y" ))("¥"))
((("\\" "-" "^" ))("¯"))
((("\\" "-" "a" ))("ã"))
((("\\" "-" "d" ))("đ"))
((("\\" "-" "e" ))("ē"))
((("\\" "-" "i" ))("ī"))
((("\\" "-" "l" ))("£"))
((("\\" "-" "n" ))("ñ"))
((("\\" "-" "o" ))("õ"))
((("\\" "-" "u" ))("ū"))
((("\\" "-" "y" ))("¥"))
((("\\" "." "." ))("˙"))
((("\\" "." "B" ))("Ḃ"))
((("\\" "." "C" ))("Ċ"))
((("\\" "." "D" ))("Ḋ"))
((("\\" "." "E" ))("Ė"))
((("\\" "." "F" ))("Ḟ"))
((("\\" "." "G" ))("Ġ"))
((("\\" "." "I" ))("İ"))
((("\\" "." "M" ))("Ṁ"))
((("\\" "." "P" ))("Ṗ"))
((("\\" "." "S" ))("Ṡ"))
((("\\" "." "T" ))("Ṫ"))
((("\\" "." "Z" ))("Ż"))
((("\\" "." "^" ))("·"))
((("\\" "." "b" ))("ḃ"))
((("\\" "." "c" ))("ċ"))
((("\\" "." "d" ))("ḋ"))
((("\\" "." "e" ))("ė"))
((("\\" "." "f" ))("ḟ"))
((("\\" "." "g" ))("ġ"))
((("\\" "." "i" ))("ı"))
((("\\" "." "m" ))("ṁ"))
((("\\" "." "p" ))("ṗ"))
((("\\" "." "s" ))("ṡ"))
((("\\" "." "t" ))("ṫ"))
((("\\" "." "z" ))("ż"))
((("\\" "/" "/" ))("\\"))
((("\\" "/" "<" ))("\\"))
((("\\" "/" "C" ))("¢"))
((("\\" "/" "O" ))("Ø"))
((("\\" "/" "T" ))("Ŧ"))
((("\\" "/" "U" ))("µ"))
((("\\" "/" "^" ))("|"))
((("\\" "/" "c" ))("¢"))
((("\\" "/" "o" ))("ø"))
((("\\" "/" "t" ))("ŧ"))
((("\\" "/" "u" ))("µ"))
((("\\" "0" "*" ))("°"))
((("\\" "0" "C" ))("©"))
((("\\" "0" "S" ))("§"))
((("\\" "0" "X" ))("¤"))
((("\\" "0" "^" ))("°"))
((("\\" "0" "c" ))("©"))
((("\\" "0" "s" ))("§"))
((("\\" "0" "x" ))("¤"))
((("\\" "1" "S" ))("¹"))
((("\\" "1" "^" ))("¹"))
((("\\" "1" "s" ))("¹"))
((("\\" "2" "S" ))("²"))
((("\\" "2" "^" ))("²"))
((("\\" "2" "s" ))("²"))
((("\\" "3" "S" ))("³"))
((("\\" "3" "^" ))("³"))
((("\\" "3" "s" ))("³"))
((("\\" ":" "-" ))("÷"))
((("\\" "<" " " ))("ˇ"))
((("\\" "<" "/" ))("\\"))
((("\\" "<" "<" ))("«"))
((("\\" "<" "C" ))("Č"))
((("\\" "<" "D" ))("Ď"))
((("\\" "<" "E" ))("Ě"))
((("\\" "<" "L" ))("Ľ"))
((("\\" "<" "N" ))("Ň"))
((("\\" "<" "R" ))("Ř"))
((("\\" "<" "S" ))("Š"))
((("\\" "<" "T" ))("Ť"))
((("\\" "<" "Z" ))("Ž"))
((("\\" "<" "c" ))("č"))
((("\\" "<" "d" ))("ď"))
((("\\" "<" "e" ))("ě"))
((("\\" "<" "l" ))("ľ"))
((("\\" "<" "n" ))("ň"))
((("\\" "<" "r" ))("ř"))
((("\\" "<" "s" ))("š"))
((("\\" "<" "t" ))("ť"))
((("\\" "<" "z" ))("ž"))
((("\\" "=" "C" ))("€"))
((("\\" "=" "L" ))("£"))
((("\\" "=" "Y" ))("¥"))
((("\\" "=" "e" ))("€"))
((("\\" "=" "l" ))("£"))
((("\\" "=" "y" ))("¥"))
((("\\" ">" " " ))("^"))
((("\\" ">" ">" ))("»"))
((("\\" ">" "A" ))("Â"))
((("\\" ">" "E" ))("Ê"))
((("\\" ">" "I" ))("Î"))
((("\\" ">" "O" ))("Ô"))
((("\\" ">" "U" ))("Û"))
((("\\" ">" "a" ))("â"))
((("\\" ">" "e" ))("ê"))
((("\\" ">" "i" ))("î"))
((("\\" ">" "o" ))("ô"))
((("\\" ">" "u" ))("û"))
((("\\" "?" "?" ))("¿"))
((("\\" "A" "\"" ))("Ä"))
((("\\" "A" "'" ))("Á"))
((("\\" "A" "(" ))("Ă"))
((("\\" "A" "*" ))("Å"))
((("\\" "A" "," ))("Ą"))
((("\\" "A" "-" ))("Ã"))
((("\\" "A" ">" ))("Â"))
((("\\" "A" "A" ))("Å"))
((("\\" "A" "E" ))("Æ"))
((("\\" "A" "^" ))("Â"))
((("\\" "A" "_" ))("ª"))
((("\\" "A" "`" ))("À"))
((("\\" "A" "~" ))("Ã"))
((("\\" "B" "." ))("Ḃ"))
((("\\" "C" "'" ))("Ć"))
((("\\" "C" "," ))("Ç"))
((("\\" "C" "." ))("Ċ"))
((("\\" "C" "/" ))("¢"))
((("\\" "C" "<" ))("Č"))
((("\\" "C" "=" ))("€"))
((("\\" "C" "0" ))("©"))
((("\\" "C" "O" ))("©"))
((("\\" "C" "o" ))("©"))
((("\\" "C" "|" ))("¢"))
((("\\" "D" "-" ))("Đ"))
((("\\" "D" "." ))("Ḋ"))
((("\\" "D" "<" ))("Ď"))
((("\\" "E" "\"" ))("Ë"))
((("\\" "E" "'" ))("É"))
((("\\" "E" "," ))("Ę"))
((("\\" "E" "-" ))("Ē"))
((("\\" "E" "." ))("Ė"))
((("\\" "E" "<" ))("Ě"))
((("\\" "E" ">" ))("Ê"))
((("\\" "E" "^" ))("Ê"))
((("\\" "E" "_" ))("Ē"))
((("\\" "E" "`" ))("È"))
((("\\" "F" "." ))("Ḟ"))
((("\\" "G" "(" ))("Ğ"))
((("\\" "G" "," ))("Ģ"))
((("\\" "G" "." ))("Ġ"))
((("\\" "G" "U" ))("Ğ"))
((("\\" "I" "\"" ))("Ï"))
((("\\" "I" "'" ))("Í"))
((("\\" "I" "," ))("Į"))
((("\\" "I" "-" ))("Ī"))
((("\\" "I" "." ))("İ"))
((("\\" "I" ">" ))("Î"))
((("\\" "I" "^" ))("Î"))
((("\\" "I" "_" ))("Ī"))
((("\\" "I" "`" ))("Ì"))
((("\\" "I" "~" ))("Ĩ"))
((("\\" "K" "," ))("Ķ"))
((("\\" "L" "'" ))("Ĺ"))
((("\\" "L" "," ))("Ļ"))
((("\\" "L" "-" ))("£"))
((("\\" "L" "<" ))("Ľ"))
((("\\" "L" "=" ))("£"))
((("\\" "L" "V" ))("|"))
((("\\" "M" "." ))("Ṁ"))
((("\\" "N" "'" ))("Ń"))
((("\\" "N" "," ))("Ņ"))
((("\\" "N" "-" ))("Ñ"))
((("\\" "N" "<" ))("Ň"))
((("\\" "N" "G" ))("Ŋ"))
((("\\" "N" "~" ))("Ñ"))
((("\\" "O" "\"" ))("Ö"))
((("\\" "O" "'" ))("Ó"))
((("\\" "O" "-" ))("Õ"))
((("\\" "O" "/" ))("Ø"))
((("\\" "O" ">" ))("Ô"))
((("\\" "O" "C" ))("©"))
((("\\" "O" "E" ))("Œ"))
((("\\" "O" "R" ))("®"))
((("\\" "O" "S" ))("§"))
((("\\" "O" "X" ))("¤"))
((("\\" "O" "^" ))("Ô"))
((("\\" "O" "_" ))("º"))
((("\\" "O" "`" ))("Ò"))
((("\\" "O" "c" ))("©"))
((("\\" "O" "x" ))("¤"))
((("\\" "O" "~" ))("Õ"))
((("\\" "P" "!" ))("¶"))
((("\\" "P" "." ))("Ṗ"))
((("\\" "R" "'" ))("Ŕ"))
((("\\" "R" "," ))("Ŗ"))
((("\\" "R" "<" ))("Ř"))
((("\\" "R" "O" ))("®"))
((("\\" "S" "!" ))("§"))
((("\\" "S" "'" ))("Ś"))
((("\\" "S" "," ))("Ş"))
((("\\" "S" "." ))("Ṡ"))
((("\\" "S" "0" ))("§"))
((("\\" "S" "1" ))("¹"))
((("\\" "S" "2" ))("²"))
((("\\" "S" "3" ))("³"))
((("\\" "S" "<" ))("Š"))
((("\\" "S" "O" ))("§"))
((("\\" "T" "-" ))("Ŧ"))
((("\\" "T" "." ))("Ṫ"))
((("\\" "T" "/" ))("Ŧ"))
((("\\" "t" "<" ))("ť"))
((("\\" "T" "H" ))("Þ"))
((("\\" "U" "\"" ))("Ü"))
((("\\" "U" "'" ))("Ú"))
((("\\" "U" "*" ))("Ů"))
((("\\" "U" "," ))("Ų"))
((("\\" "U" "-" ))("ū"))
((("\\" "U" "/" ))("µ"))
((("\\" "U" ">" ))("Û"))
((("\\" "U" "^" ))("Û"))
((("\\" "U" "_" ))("ū"))
((("\\" "U" "`" ))("Ù"))
((("\\" "U" "~" ))("Ũ"))
((("\\" "V" "L" ))("|"))
((("\\" "W" "^" ))("Ŵ"))
((("\\" "X" "0" ))("¤"))
((("\\" "X" "O" ))("¤"))
((("\\" "X" "o" ))("¤"))
((("\\" "Y" "\"" ))("Ÿ"))
((("\\" "Y" "'" ))("Ý"))
((("\\" "Y" "-" ))("¥"))
((("\\" "Y" "=" ))("¥"))
((("\\" "Y" "^" ))("Ŷ"))
((("\\" "Z" "'" ))("Ź"))
((("\\" "Z" "." ))("Ż"))
((("\\" "Z" "<" ))("Ž"))
((("\\" "^" " " ))("^"))
((("\\" "^" "-" ))("¯"))
((("\\" "^" "." ))("·"))
((("\\" "^" "/" ))("|"))
((("\\" "^" "0" ))("°"))
((("\\" "^" "1" ))("¹"))
((("\\" "^" "2" ))("²"))
((("\\" "^" "3" ))("³"))
((("\\" "^" "A" ))("Â"))
((("\\" "^" "E" ))("Ê"))
((("\\" "^" "I" ))("Î"))
((("\\" "^" "O" ))("Ô"))
((("\\" "^" "U" ))("Û"))
((("\\" "^" "W" ))("Ŵ"))
((("\\" "^" "Y" ))("Ŷ"))
((("\\" "^" "_" ))("¯"))
((("\\" "^" "a" ))("â"))
((("\\" "^" "e" ))("ê"))
((("\\" "^" "i" ))("î"))
((("\\" "^" "o" ))("ô"))
((("\\" "^" "u" ))("û"))
((("\\" "^" "w" ))("ŵ"))
((("\\" "^" "y" ))("ŷ"))
((("\\" "_" "A" ))("ª"))
((("\\" "_" "E" ))("Ē"))
((("\\" "_" "I" ))("Ī"))
((("\\" "_" "O" ))("º"))
((("\\" "_" "U" ))("Ū"))
((("\\" "_" "^" ))("¯"))
((("\\" "_" "_" ))("¯"))
((("\\" "_" "a" ))("ª"))
((("\\" "_" "e" ))("ē"))
((("\\" "_" "i" ))("ī"))
((("\\" "_" "o" ))("º"))
((("\\" "_" "u" ))("ū"))
((("\\" "`" " " ))("`"))
((("\\" "`" "A" ))("À"))
((("\\" "`" "E" ))("È"))
((("\\" "`" "I" ))("Ì"))
((("\\" "`" "O" ))("Ò"))
((("\\" "`" "U" ))("Ù"))
((("\\" "`" "a" ))("à"))
((("\\" "`" "e" ))("è"))
((("\\" "`" "i" ))("ì"))
((("\\" "`" "o" ))("ò"))
((("\\" "`" "u" ))("ù"))
((("\\" "a" "\"" ))("ä"))
((("\\" "a" "'" ))("á"))
((("\\" "a" "(" ))("ă"))
((("\\" "a" "*" ))("å"))
((("\\" "a" "," ))("ą"))
((("\\" "a" "-" ))("ã"))
((("\\" "a" ">" ))("â"))
((("\\" "a" "^" ))("â"))
((("\\" "a" "_" ))("ª"))
((("\\" "a" "`" ))("à"))
((("\\" "a" "a" ))("å"))
((("\\" "a" "e" ))("æ"))
((("\\" "a" "~" ))("ã"))
((("\\" "b" "." ))("ḃ"))
((("\\" "c" "," ))("ç"))
((("\\" "c" "." ))("ċ"))
((("\\" "c" "/" ))("¢"))
((("\\" "c" "0" ))("©"))
((("\\" "c" "<" ))("č"))
((("\\" "c" "O" ))("©"))
((("\\" "c" "o" ))("©"))
((("\\" "c" "|" ))("¢"))
((("\\" "d" "-" ))("đ"))
((("\\" "d" "." ))("ḋ"))
((("\\" "d" "<" ))("ď"))
((("\\" "e" "\"" ))("ë"))
((("\\" "e" "'" ))("é"))
((("\\" "e" "," ))("ę"))
((("\\" "e" "-" ))("ē"))
((("\\" "e" "." ))("ė"))
((("\\" "e" "=" ))("€"))
((("\\" "e" "<" ))("ě"))
((("\\" "e" ">" ))("ê"))
((("\\" "e" "^" ))("ê"))
((("\\" "e" "_" ))("ē"))
((("\\" "e" "`" ))("è"))
((("\\" "f" "." ))("ḟ"))
((("\\" "g" "(" ))("ğ"))
((("\\" "g" "," ))("ģ"))
((("\\" "g" "." ))("ġ"))
((("\\" "g" "U" ))("ğ"))
((("\\" "i" "\"" ))("ï"))
((("\\" "i" "'" ))("í"))
((("\\" "i" "," ))("į"))
((("\\" "i" "-" ))("ī"))
((("\\" "i" "." ))("ı"))
((("\\" "i" ">" ))("î"))
((("\\" "i" "^" ))("î"))
((("\\" "i" "_" ))("ī"))
((("\\" "i" "`" ))("ì"))
((("\\" "i" "~" ))("ĩ"))
((("\\" "k" "," ))("ķ"))
((("\\" "k" "k" ))("ĸ"))
((("\\" "l" "'" ))("ĺ"))
((("\\" "l" "," ))("ļ"))
((("\\" "l" "-" ))("£"))
((("\\" "l" "<" ))("ľ"))
((("\\" "l" "=" ))("£"))
((("\\" "l" "v" ))("|"))
((("\\" "m" "." ))("ṁ"))
((("\\" "n" "'" ))("ń"))
((("\\" "n" "," ))("ņ"))
((("\\" "n" "-" ))("ñ"))
((("\\" "n" "<" ))("ň"))
((("\\" "n" "g" ))("ŋ"))
((("\\" "n" "~" ))("ñ"))
((("\\" "o" "\"" ))("ö"))
((("\\" "o" "'" ))("ó"))
((("\\" "o" "-" ))("õ"))
((("\\" "o" "/" ))("ø"))
((("\\" "o" ">" ))("ô"))
((("\\" "o" "C" ))("©"))
((("\\" "o" "X" ))("¤"))
((("\\" "o" "^" ))("ô"))
((("\\" "o" "_" ))("º"))
((("\\" "o" "`" ))("ò"))
((("\\" "o" "c" ))("©"))
((("\\" "o" "e" ))("œ"))
((("\\" "o" "s" ))("§"))
((("\\" "o" "x" ))("¤"))
((("\\" "o" "~" ))("õ"))
((("\\" "p" "!" ))("¶"))
((("\\" "p" "." ))("ṗ"))
((("\\" "r" "'" ))("ŕ"))
((("\\" "r" "," ))("ŗ"))
((("\\" "r" "<" ))("ř"))
((("\\" "s" "!" ))("§"))
((("\\" "s" "'" ))("ś"))
((("\\" "s" "," ))("ş"))
((("\\" "s" "." ))("ṡ"))
((("\\" "s" "0" ))("§"))
((("\\" "s" "1" ))("¹"))
((("\\" "s" "2" ))("²"))
((("\\" "s" "3" ))("³"))
((("\\" "s" "<" ))("š"))
((("\\" "s" "o" ))("§"))
((("\\" "s" "s" ))("ß"))
((("\\" "t" "-" ))("ŧ"))
((("\\" "t" "." ))("ṫ"))
((("\\" "t" "/" ))("ŧ"))
((("\\" "t" "<" ))("ť"))
((("\\" "t" "h" ))("þ"))
((("\\" "u" "\"" ))("ü"))
((("\\" "u" "'" ))("ú"))
((("\\" "u" "*" ))("ů"))
((("\\" "u" "," ))("ų"))
((("\\" "u" "-" ))("ū"))
((("\\" "u" "/" ))("µ"))
((("\\" "u" ">" ))("û"))
((("\\" "u" "^" ))("û"))
((("\\" "u" "_" ))("ū"))
((("\\" "u" "`" ))("ù"))
((("\\" "u" "~" ))("ũ"))
((("\\" "v" "Z" ))("Ž"))
((("\\" "v" "l" ))("|"))
((("\\" "v" "z" ))("ž"))
((("\\" "w" "^" ))("ŵ"))
((("\\" "x" "0" ))("¤"))
((("\\" "x" "O" ))("¤"))
((("\\" "x" "o" ))("¤"))
((("\\" "x" "x" ))("×"))
((("\\" "y" "\"" ))("ÿ"))
((("\\" "y" "'" ))("ý"))
((("\\" "y" "-" ))("¥"))
((("\\" "y" "=" ))("¥"))
((("\\" "y" "^" ))("ŷ"))
((("\\" "z" "'" ))("ź"))
((("\\" "z" "." ))("ż"))
((("\\" "z" "<" ))("ž"))
((("\\" "|" "C" ))("¢"))
((("\\" "|" "c" ))("¢"))
((("\\" "~" " " ))("~"))
((("\\" "~" "A" ))("Ã"))
((("\\" "~" "I" ))("Ĩ"))
((("\\" "~" "N" ))("Ñ"))
((("\\" "~" "O" ))("Õ"))
((("\\" "~" "U" ))("Ũ"))
((("\\" "~" "a" ))("ã"))
((("\\" "~" "i" ))("ĩ"))
((("\\" "~" "n" ))("ñ"))
((("\\" "~" "o" ))("õ"))
((("\\" "~" "u" ))("ũ"))
))

(define latin-im-rule
  (append ascii-rule latin-compose-rule))

(define latin-init-handler
  (lambda (id im arg)
    (generic-context-new id im latin-im-rule #f)))

(generic-register-im
 'latin
 ""
 "UTF-8"
 ;; I think that the name "euro" is not appropriate since it
 ;; represents nation or geographic region.  -- YamaKen 2005-01-29
 (N_ "Latin characters")
 (N_ "Latin characters mainly used for Latin and German languages")
 latin-init-handler)
