% umoci-unpack(1) # umoci unpack - Unpacks an OCI image tag into an runtime bundle
% Aleksa Sarai
% DECEMBER 2016
# NAME
umoci unpack - Unpacks an OCI image tag into an runtime bundle

# SYNOPSIS
**umoci unpack**
**--image**=*image*[:*tag*]
*bundle*

# DESCRIPTION
Extracts all of the layers (deterministically) to an OCI runtime bundle at the
path *bundle*, as well as generating an OCI runtime configuration that
corresponds to the image's configuration. In addition, an **mtree**(8)
specification is generated at the time of unpacking to allow filesystem deltas
to be generated by **umoci-repack**(1) and thus allowing for the creation of
layered OCI images.

# OPTIONS
The global options are defined in **umoci**(1).

**--image**=*image*[:*tag*]
  The OCI image tag which will be extracted to the *bundle*. *image* must be a
  path to a valid OCI image and *tag* must be a valid tag in the image. If
  *tag* is not provided it defaults to "latest".

**--uid-map**=[*value*]
  Specifies a UID mapping to use while unpacking layers. This is used in a
  similar fashion to **user_namespaces**(7), and is of the form
  **container:host[:size]**.

**--gid-map**=[*value*]
  Specifies a GID mapping to use while unpacking layers. This is used in a
  similar fashion to **user_namespaces**(7), and is of the form
  **container:host[:size]**.

**--rootless**
  Enable rootless unpacking support. This allows for **umoci-unpack**(1) and
  **umoci-repack**(1) to be used as an unprivileged user. Use of this flag
  implies **--uid-map=0:$(id -u):1** and **--gid-map=0:$(id -g):1**, as well as
  enabling several features to fake parts of the unpacking in the attempt to
  generate an as-close-as-possible extraction of the filesystem. Note that it
  is almost always not possible to perfectly extract an OCI image with
  **--rootless**, but it will be as close as possible.

# EXAMPLE
The following downloads an image from a **docker**(1) registry using
**skopeo**(1), unpacks said image and then creates a new container using the
extracted OCI runtime bundle with **runc**(8). Then, the image is repacked with
**umoci-repack**(1).

```
% skopeo copy docker://opensuse/amd64:42.2 oci:image:latest
# umoci unpack --image image bundle
# runc run -b bundle ctr
[ container session ]
# umoci repack --image image bundle
```

With **--rootless** it is also possible to do the above example without root
privileges. **umoci** will generate a configuration that works with rootless
containers in **runc**(8).

```
% skopeo copy docker://opensuse/amd64:42.2 oci:image:latest
% umoci unpack --image image --rootless bundle
% runc --root $HOME/runc run -b bundle ctr
[ rootless container session ]
% umoci repack --image image --rootless bundle
```

# SEE ALSO
**umoci**(1), **umoci-repack**(1), **runc**(8)
