/**
 * Handles all the related work to injecting the 'external' extension into the
 * content script (well, more precisely the current environment), and the proxy
 * responsbile for handling the API requests in a webapplication.
 * 
 */
(function (currentWindow) {
   var aWindow = currentWindow;
   var plugin = null;
   var service = null;
   var api = null;

   var webkitNotificationUnityBackend = {
     showNotification: function (iconUrl, title, body) {
       try {
         var notification = plugin.notification_new(title, body, null/*iconUrl*/);
         plugin.notification_show(notification, null);
         plugin.notification_destroy(notification);
       }
       catch (err) {
         // TODO decipher/inject proper & general logging policy for user side of API
       }
     }
   };

   /**
    * Inserts a given script in the webpage.
    * Needs chrome.extension functionality.
    * 
    * @param path of file to be injected (part of the extension)
    */
   var insertScriptIntoWebpage = function (path) {
     var script = document.createElement ('script');
     script.type = 'text/javascript';
     script.src = chrome.extension.getURL (path);
     document.getElementsByTagName("head")[0].appendChild (script);
   };

   var injectApiProxy = function () {

     // 1. inject a piece of javascript proxying all the requests
     // to the unity webapps api
     insertScriptIntoWebpage('webkitnotif-wrapper-builder.js');
     insertScriptIntoWebpage('unity-api-page-proxy-builder-gen.js');
     insertScriptIntoWebpage('unity-api-page-proxy.js');

     function makeWebpageCallback (id) {
       // TODO/FIXME: add support for callback params (needed for DnD)
       return function () {
         var d = document.createElement ("textarea");
         var e = document.createEvent ("Events");
         d.style.cssText = "display:none;";
         d.value = id;
         d.addEventListener ("unity-webapps-chromium-api-com-link-callback-called-ack"
                             , function() { d.parentNode.removeChild (d); }
                             , true);
         document.body.appendChild (d);
         e.initEvent ("unity-webapps-chromium-api-com-link-callback-called", false, true);
         d.dispatchEvent (e);
       };
     };

     // TODO: should be shared / generated w/ web page code
     var isIterableObject = function(obj) {
        if (obj === undefined || obj === null) {
          return false;
        }
       var t = typeof(obj);
       var types = {'string': 0, 'function': 0, 'number': 0, 'undefined': 0, 'boolean': 0};
       return types[t] === undefined;
     };

     /**
      * Wraps callback ids in proper callback that dispatch to the
      * webpage thru a proper event
      *
      */
     function wrapCallbackIds (obj) {
       if ( ! isIterableObject(obj)) {
         return obj;
       }
       if (obj
           && obj.hasOwnProperty('callbackid')
           && obj.callbackid != null) {
         return makeWebpageCallback (obj.callbackid);
       }

       var ret = (obj instanceof Array) ? [] : {};
       for (var key in obj) {
         if (obj.hasOwnProperty(key)) {

           if (isIterableObject (obj[key])) {

             if (obj[key].callbackid != null) {
               ret[key] = makeWebpageCallback (obj[key].callbackid);
             }
             else {
               ret[key] = wrapCallbackIds (obj[key]);
             }
           }
           else {
             ret[key] = obj[key];
           }
         }
       }
       return ret;
     };

     // 2. open the communication mean between the two

     // TODO has the implicit knowledge of who's behind ...
     var dispatchActualFunctionCall = function (funcname, args) {
       var funcnames = funcname.split('.');
       var reducetarget = api;

       // a bit hacky
       if (funcnames[0] == 'webkitNotifications') {
         funcnames.shift();
         reducetarget = webkitNotificationUnityBackend;
       }
       try {
         // Assumes that we are calling a 'callable' from a succession of objects
         funcnames.reduce (
           function (prev, cur) {
             return typeof prev[cur] == "function" ? prev[cur].bind(prev) : prev[cur];
           }, reducetarget).apply (null, args);
       } catch (err) {
         console.log ('Error while dispatching call to ' + funcnames.join('.') + ': ' + err);
       }
     };
     
     document.addEventListener("unity-webapps-chromium-api-com-link"
                               , function(event) {
                                 var from = event.target;
                                 if (from) {
                                   var type = from.getAttribute("data-eventType");

                                   var args = JSON.parse(from.value);
                                   args = args.map (function (arg) { return wrapCallbackIds (arg); });

                                   // Actuall call, e.g. 'Notification.showNotification("a","b")
                                   // being reduces to successive calls to associated objects:
                                   // Notification, showNotification
                                   // 
                                   // TODO add proper error handling
                                   dispatchActualFunctionCall(type, args);
                                 }

                                 // send ack event to allow cleanup
                                 var ret = document.createEvent('Events');
                                 ret.initEvent('unity-webapps-chromium-api-com-link-ack', true, false);
                                 from.dispatchEvent(ret);
                               }
                               , true);
   };

   function initializePluginConnection (logger){
     plugin = document.getElementById ("unityChromiumExtensionId");
     if ( ! plugin) {
       logger ('Could not bind to the scriptable NPAPI plugin');
     }
     else {
       logger ("Got a plugin object: " + plugin);
       
       // initialize webkitnotification backend & fallback
       try {
         plugin.notification_init("chromium");
       }
       catch (err) {
         logger ("Error while trying to initialize notify OSD NPAPI connection");
         // decide to bail out
         return;
       }
       UnityWebappsWebkitNotificationApiPageProxyBuilder(webkitNotificationUnityBackend, aWindow);

       // initialize unity API binding
       service = plugin.service_new ();
       logger ("Service object created: " + service);

       // global plugin initialization
       api = UnityGlobalPropertyInitializer.makeCallback (plugin, service, logger)(aWindow);
     }
   }

   initializePluginConnection (function (msg) {
				 if (consoleService && consoleService.logStringMessage) {
				   consoleService.logStringMessage ("Unity Webapps: " + msg);
				 }
			       });

   // handle the proxy side of the api which is being injected on the
   //  webpage
   injectApiProxy();
   
   var windowExternal = aWindow.external;
   function unity() {
   }
   unity.prototype = {
     __proto__: windowExternal,
     getUnityObject: function (version) {
       console.log ('getUnityObject called with version ' + version);
       if (version === 1)
         return api;
       throw new Error("incorrect version");
     }
   };
   aWindow.external = new unity();
 }
)(window);

