// ==UserScript==
// @include        https://mail.google.com/*
// @require        utils.js
// @require        google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);
var pane = null;

function getComposeMessageNode() {
    return document.evaluate('//div[@role="navigation"]/div[1]/div[1]/div[1][@role="button"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
}

function getNumber(str) {
    try {
        var onlyNumber = str.match(/\(([0-9]|,|\s)+\)/)[0].match(/([0-9]|,|\s)+/)[0];

        return onlyNumber.replace(/(,|\s)/g, "");
    } catch (x) {
        return '0';
    }
}

function getLabels() {
    var i, res = [];

    var snapshot = document.evaluate('//div[@role="navigation"]/div[2]/div/div/div[7]/div/*/div/div/div[2]/span/a',
                                     document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);

    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);

        res.push({ name: unescape(node.href.match(/#label\/(.+)$/)[1]),
                   count: getNumber(node.textContent),
                   link: node.href });
    }

    return res;
}

function checkMessagesCount() {
    var tag = document.evaluate('//div/div[2]/div/div/div/div/div[@role="button"]/span', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

    if (tag.textContent !== 'Gmail' && tag.textContent !== 'Mail') {
        throw new Error();
    }

    var indicators = [];

    var inboxLink = document.evaluate('//div[@role="navigation"]/div/div/div/div/div/div/div/div/div/span/a', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

    if (!inboxLink || !inboxLink.href || !inboxLink.text) {
        return indicators;
    }
    var numMessages = getNumber(inboxLink.text);

    indicators.push({ name: _("Inbox"),
                      count: numMessages,
                      callback: makeRedirector(inboxLink.href) });
    var i, labels = getLabels();
    for (i = 0; i < labels.length; i++) {
        indicators.push({ name: trim(labels[i].name), count: labels[i].count, callback: makeRedirector(labels[i].link) });
    }

    return indicators;
}

/**
 * Validates the page for functional tests.
 *
 */
function selfTest() {
    if (!getComposeMessageNode()) {
        return;
    }
    if (!checkMessagesCount().length) {
        return;
    }

    reportTestState('PASS SELF TEST');
}

function isCorrectPage() {
    var i, ids = ['hist_frame', 'js_frame'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function doMatrixIntegration() {
    doMainMenuIntegration(document);

    var i, labels = getLabels();
    for (i = 0; i < labels.length; i++) {
        Unity.addAction('/' + labels[i].name, makeRedirector(labels[i].link));
    }
}

function unityLoaded() {
    var composeNewMessage = wrapCallback(function () {
        var compose = getComposeMessageNode();
        click(compose);
    });

    Unity.MessagingIndicator.addAction(_("Compose New Message"),
                                       composeNewMessage);
    Unity.Launcher.addAction(_("Compose New Message"),
                             composeNewMessage);

    var indicatorsController = new Indicators(checkMessagesCount);

    window.onpopstate = function () {
        var hash = window.location.hash;
        var label = null;
        if (hash.match(/#label\/(.+)/)) {
            label = unescape(hash.match(/#label\/(.+)/)[1]);
        } else if (hash === '#inbox') {
            label = _("Inbox");
        } else {
            return;
        }
        indicatorsController.visited(label);
    };

    doMatrixIntegration();

    selfTest();
}

if (isCorrectPage()) {
    setTimeout(wrapCallback(function wait() {
        pane = document.evaluate('//div[@role="navigation"]',
                                 document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

        if (!pane || !document.getElementsByClassName("nU")) {
            setTimeout(wait, 1000);
            return;
        }
        var gmaillogin;
        try {
            gmaillogin = document.evaluate('//div[@role="navigation"]/div/div[1]/div[3]/div/ol/li[4]/div/div/div/div[2]/span[2]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;
        } catch (gmail_err) {
            gmaillogin = "";
        }

        var gappslogin;
        try {
            gappslogin = document.evaluate('//div[@role="navigation"]/div/div[1]/div[3]/div/ol/li[4]/div/div/div/div[3]/span[2]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;
        } catch (gapps_err) {
            gappslogin = "";
        }
        var login = gmaillogin.indexOf("@") !== -1 ? gmaillogin : gappslogin.indexOf("@") !== -1 ? gappslogin : "";

        Unity.init({ name: "GMail",
                     login: login,
                     iconUrl: "icon://unity-webapps-gmail",
                     homepage: 'https://mail.google.com',
                     domain: 'mail.google.com',
                     onInit: wrapCallback(unityLoaded) });
    }), 2000);
}
