# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Publish various files from source tree or build area."""


import os
import shutil

import unperishlib


class Publish(unperishlib.Operation):

    """Publish various files from source tree and build area."""

    name = "publish"
    
    required_options = ["publish_to"]
    
    def add_options(self, parser):
        parser.add_public_option("--publish-to", metavar="DIR",
                                 help="Copy files to DIR to publish them.")

        parser.add_public_option("--publish-file", action="append", 
                                 metavar="FILE", help="""\
Add FILE to list of files to publish. Default list: %default.""")
        parser.set_defaults(publish_file=["NEWS", "README"])

        parser.add_public_option("--publish-nothing", action="store_const",
                                 const=None, dest="publish_file",
                                 help="Clear list of files to publish.")

    def do_it(self, options):
        for filename in options.publish_file:
            srcpath = os.path.join(options.directory, filename)
            if os.path.exists(srcpath):
                shutil.copy(srcpath, options.publish_to)

        if hasattr(options, "upstream_tarball") and options.upstream_tarball:
            if os.path.exists(options.upstream_tarball):
                shutil.copy(options.upstream_tarball, options.publish_to)

        if hasattr(options, "changelog") and options.changelog:
            if os.path.exists(options.changelog):
                shutil.copy(options.changelog, options.publish_to)
