/*
	file automatically generated by make_test_files.pl
	Tue May 16 16:46:35 2023
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for DISTR_CONT
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_distr_cont_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



#include<unuran_config.h>

/* prototypes */

#define COMPARE_SAMPLE_SIZE  (500)
#define VIOLATE_SAMPLE_SIZE   (20)

double pdf(double x, const UNUR_DISTR *distr);
double dpdf(double x, const UNUR_DISTR *distr);
double cdf(double x, const UNUR_DISTR *distr);
double invcdf(double x, const UNUR_DISTR *distr);
double hr(double x, const UNUR_DISTR *distr);

int unur_distr_cont_set_pedantic(UNUR_PAR *par, int pedantic);
int unur_distr_cont_chg_verify(UNUR_GEN *gen, int verify);




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



double pdf(double x ATTRIBUTE__UNUSED, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }
double dpdf(double x ATTRIBUTE__UNUSED, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }
double cdf(double x ATTRIBUTE__UNUSED, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }
double invcdf(double x ATTRIBUTE__UNUSED, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }
double hr(double x ATTRIBUTE__UNUSED, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { return 1.; }

int unur_distr_cont_set_pedantic(UNUR_PAR *par ATTRIBUTE__UNUSED, int pedantic ATTRIBUTE__UNUSED) {
   return UNUR_FAILURE; 
}

int unur_distr_cont_chg_verify(UNUR_GEN *gen, int verify)
{
  if (unur_arou_chg_verify(gen,verify)==UNUR_SUCCESS) return UNUR_SUCCESS;
  if (unur_srou_chg_verify(gen,verify)==UNUR_SUCCESS) return UNUR_SUCCESS;
  return UNUR_FAILURE;
}	

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,42,(unur_distr_cont_set_pdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,42,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,45,(unur_distr_cont_set_dpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,45,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,48,(unur_distr_cont_set_logpdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,48,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,51,(unur_distr_cont_set_dlogpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,51,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,54,(unur_distr_cont_set_cdf( distr, cdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,54,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,57,(unur_distr_cont_set_invcdf( distr, invcdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,57,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,60,(unur_distr_cont_set_hr( distr, hr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,60,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,63,(unur_distr_cont_set_pdfstr( distr, "pdf" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,63,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,66,(unur_distr_cont_set_logpdfstr( distr, "pdf" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_distr_cont_set_cdfstr( distr, "cdf" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,72,(unur_distr_cont_set_hrstr( distr, "hr" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,72,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,75,(unur_distr_cont_set_pdfparams( distr, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,75,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,78,(unur_distr_cont_set_pdfparams_vec( distr, 0, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,78,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,81,(unur_distr_cont_set_domain( distr, 0., 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,81,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,84,(unur_distr_cont_set_mode( distr, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,87,(unur_distr_cont_set_center( distr, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,87,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,90,(unur_distr_cont_set_pdfarea( distr, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,90,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
	distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,97,(unur_distr_cont_set_pdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,97,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,100,(unur_distr_cont_set_dpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,100,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,103,(unur_distr_cont_set_logpdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,106,(unur_distr_cont_set_dlogpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,109,(unur_distr_cont_set_cdf( distr, cdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,109,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,112,(unur_distr_cont_set_invcdf( distr, invcdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,112,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,115,(unur_distr_cont_set_hr( distr, hr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,115,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,118,(unur_distr_cont_set_pdfstr( distr, "exp(-x)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,118,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,121,(unur_distr_cont_set_pdfstr( distr, "-x" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,121,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,124,(unur_distr_cont_set_cdfstr( distr, "exp(-x)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,124,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,127,(unur_distr_cont_set_hrstr( distr, "exp(-x)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,127,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,130,(unur_distr_cont_set_pdfparams( distr, NULL, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,130,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,133,(unur_distr_cont_set_domain( distr, 0., 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,133,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,136,(unur_distr_cont_set_mode( distr, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,136,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,139,(unur_distr_cont_set_center( distr, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,139,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,142,(unur_distr_cont_set_pdfarea( distr, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,142,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,149,(unur_distr_cont_set_pdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,149,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,152,(unur_distr_cont_set_dpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,152,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,155,(unur_distr_cont_set_logpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,155,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,158,(unur_distr_cont_set_dlogpdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,158,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,161,(unur_distr_cont_set_cdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,161,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,164,(unur_distr_cont_set_invcdf( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,164,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,167,(unur_distr_cont_set_hr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,167,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,170,(unur_distr_cont_set_pdfstr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,170,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,173,(unur_distr_cont_set_logpdfstr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,173,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,176,(unur_distr_cont_set_cdfstr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,176,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,179,(unur_distr_cont_set_hrstr( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,179,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,182,(unur_distr_cont_set_pdfparams( distr, NULL, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,182,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
   double pv[] = {1.,2.,3.};
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,190,(unur_distr_cont_set_pdfstr( distr, "" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,190,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,193,(unur_distr_cont_set_pdfstr( distr, "x * y * z" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,193,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,196,(unur_distr_cont_set_pdfstr( distr, "beta(2.)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,196,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,199,(unur_distr_cont_set_logpdfstr( distr, "" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,199,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,202,(unur_distr_cont_set_logpdfstr( distr, "x * y * z" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,202,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,205,(unur_distr_cont_set_logpdfstr( distr, "beta(2.)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,205,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,208,(unur_distr_cont_set_cdfstr( distr, "" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,208,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,211,(unur_distr_cont_set_cdfstr( distr, "beta(2.)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,211,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,214,(unur_distr_cont_set_hrstr( distr, "" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,214,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,217,(unur_distr_cont_set_pdfparams( distr, pv, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,217,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,220,(unur_distr_cont_set_pdfparams( distr, pv, UNUR_DISTR_MAXPARAMS +1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,220,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,223,(unur_distr_cont_set_pdfparams_vec( distr, -1, pv, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,223,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,226,(unur_distr_cont_set_pdfparams_vec( distr, 100000, pv, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,226,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,229,(unur_distr_cont_set_domain( distr, 0., -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,229,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,232,(unur_distr_cont_set_pdfarea( distr, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,232,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid set parameters */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_normal(NULL,0); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,239,(unur_distr_cont_set_pdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,239,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,242,(unur_distr_cont_set_dpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,242,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,245,(unur_distr_cont_set_logpdf( distr, pdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,245,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,248,(unur_distr_cont_set_dlogpdf( distr, dpdf )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,248,UNUR_ERR_DISTR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   double a, b;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,261,(unur_distr_cont_get_pdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,261,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,264,(unur_distr_cont_get_dpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,264,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,267,(unur_distr_cont_get_logpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,267,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,270,(unur_distr_cont_get_dlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,270,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,273,(unur_distr_cont_get_cdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,273,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,276,(unur_distr_cont_get_invcdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,276,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,279,(unur_distr_cont_get_hr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,279,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,282,(unur_distr_cont_get_pdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,282,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,285,(unur_distr_cont_get_dpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,285,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,288,(unur_distr_cont_get_logpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,288,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,291,(unur_distr_cont_get_dlogpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,291,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,294,(unur_distr_cont_get_cdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,294,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,297,(unur_distr_cont_get_hrstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,297,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,300,(unur_distr_cont_get_pdfparams( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,300,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,303,(unur_distr_cont_get_pdfparams_vec( distr, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,303,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,306,(unur_distr_cont_get_domain( distr, &a, &b )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,306,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,309,(unur_distr_cont_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,309,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,312,(unur_distr_cont_get_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,312,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   double a,b;
   const double *ar;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,321,(unur_distr_cont_get_pdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,321,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,324,(unur_distr_cont_get_dpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,324,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,327,(unur_distr_cont_get_logpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,327,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,330,(unur_distr_cont_get_dlogpdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,330,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,333,(unur_distr_cont_get_cdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,333,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,336,(unur_distr_cont_get_invcdf( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,336,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,339,(unur_distr_cont_get_hr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,339,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,342,(unur_distr_cont_get_pdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,342,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,345,(unur_distr_cont_get_dpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,345,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,348,(unur_distr_cont_get_logpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,348,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,351,(unur_distr_cont_get_dlogpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,351,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,354,(unur_distr_cont_get_cdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,354,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,357,(unur_distr_cont_get_hrstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,357,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,360,(unur_distr_cont_get_pdfparams( distr, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,360,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,363,(unur_distr_cont_get_pdfparams_vec( distr, 0, &ar )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,363,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,366,(unur_distr_cont_get_domain( distr, &a, &b )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,366,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,369,(unur_distr_cont_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,369,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,372,(unur_distr_cont_get_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,372,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* parameters not unknown */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,379,(unur_distr_cont_get_pdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,379,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,382,(unur_distr_cont_get_dpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,382,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,385,(unur_distr_cont_get_logpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,385,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,388,(unur_distr_cont_get_dlogpdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,388,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,391,(unur_distr_cont_get_cdfstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,391,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,394,(unur_distr_cont_get_hrstr( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,394,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,397,(unur_distr_cont_get_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,397,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,400,(unur_distr_cont_get_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,400,UNUR_ERR_DISTR_GET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,411,(unur_distr_cont_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,411,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,414,(unur_distr_cont_upd_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,414,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,421,(unur_distr_cont_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,421,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,424,(unur_distr_cont_upd_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,424,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,431,(unur_distr_cont_upd_mode( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,431,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,434,(unur_distr_cont_upd_pdfarea( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,434,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,453,(unur_distr_cont_eval_pdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,453,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,456,(unur_distr_cont_eval_dpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,456,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,459,(unur_distr_cont_eval_logpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,459,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,462,(unur_distr_cont_eval_dlogpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,462,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,465,(unur_distr_cont_eval_cdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,465,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,468,(unur_distr_cont_eval_invcdf( 0.5, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,468,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,471,(unur_distr_cont_eval_hr( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,471,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,478,(unur_distr_cont_eval_pdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,478,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,481,(unur_distr_cont_eval_dpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,481,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,484,(unur_distr_cont_eval_logpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,484,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,487,(unur_distr_cont_eval_dlogpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,487,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,490,(unur_distr_cont_eval_cdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,490,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,493,(unur_distr_cont_eval_invcdf( 0.5, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,493,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,496,(unur_distr_cont_eval_hr( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,496,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* missing data */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,503,(unur_distr_cont_eval_pdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,503,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,506,(unur_distr_cont_eval_dpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,506,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,509,(unur_distr_cont_eval_logpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,509,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,512,(unur_distr_cont_eval_dlogpdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,512,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,515,(unur_distr_cont_eval_cdf( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,515,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,518,(unur_distr_cont_eval_invcdf( 0.5, distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,518,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,521,(unur_distr_cont_eval_hr( 1., distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,521,UNUR_ERR_DISTR_DATA)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* check for memory leaks */
UNUR_DISTR *distr = NULL;
   double x[] = { 1., 2., 3. };
   distr = unur_distr_cont_new(); 


unur_reset_errno();
unur_distr_cont_set_pdfparams_vec( distr, 0, x, 3 );
n_tests_failed += (check_errorcode(TESTLOG,529,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[12];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 12 */
{
fpm[0] = 3.;
fpm[1] = 4.;
distr[0] = unur_distr_beta_w_pdf_from_logpdf(fpm,2);
}

{
distr[1] = unur_distr_cauchy_w_pdf_from_logpdf(NULL,0);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[2] = unur_distr_cauchy_w_pdf_from_logpdf(fpm,2);
}

{
distr[3] = unur_distr_exponential_w_pdf_from_logpdf(NULL,0);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[4] = unur_distr_exponential_w_pdf_from_logpdf(fpm,2);
}

{
fpm[0] = 1.;
distr[5] = unur_distr_gamma_w_pdf_from_logpdf(fpm,1);
}

{
fpm[0] = 1.;
fpm[1] = 4.;
distr[6] = unur_distr_gamma_w_pdf_from_logpdf(fpm,2);
}

{
fpm[0] = 3.;
distr[7] = unur_distr_gamma_w_pdf_from_logpdf(fpm,1);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[8] = unur_distr_gamma_w_pdf_from_logpdf(fpm,2);
}

{
distr[9] = unur_distr_normal_w_pdf_from_logpdf(NULL,0);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[10] = unur_distr_normal_w_pdf_from_logpdf(fpm,2);
}

{
fpm[0] = 5.;
distr[11] = unur_distr_powerexponential_w_pdf_from_logpdf(fpm,1);
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 36 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_arou_new(distr_localcopy);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_srou_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));

	printf("\n(verify hat) "); fflush(stdout);

/* verify hat tests: 36 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nVerify Hat Test (squeeze <= PDF <= hat):\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_usedars(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_arou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
unur_arou_set_cpoints( par, 8, NULL );
unur_arou_set_usedars(par,1);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_srou_new(distr_localcopy);
	unur_distr_cont_set_pedantic(par,0);
	gen = unur_init(par);
	if (gen) unur_distr_cont_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_distr_cont_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_distr_cont_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_distr_cont_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_distr_cont_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 640983;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 640983;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("distr_cont: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

