/*
	file automatically generated by make_test_files.pl
	Tue May 16 16:46:35 2023
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for TABL
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
double pdf( double x, UNUR_DISTR *distr );

double pdf_negative( double x, const UNUR_DISTR *distr );
double pdf_partnegative( double x, const UNUR_DISTR *distr );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* pdf with negative value */
double pdf_negative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ return (-x*x); }

/* pdf with partial negative value */
double pdf_partnegative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)  
{ return ((x>-0.89 && x<0.89) ? -1.: exp(-x*x)); }


/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,29,(unur_tabl_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,29,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,35,(unur_tabl_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,35,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
/* pdf */
n_tests_failed += (check_expected_NULL(TESTLOG,42,(unur_tabl_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,42,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   double slopes[2] = {0.,1.};
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,53,(unur_tabl_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,53,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,56,(unur_tabl_set_useear( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,56,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,59,(unur_tabl_set_usedars( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,59,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,62,(unur_tabl_set_darsfactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,62,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,65,(unur_tabl_set_variant_splitmode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,65,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,68,(unur_tabl_set_areafraction( par, 0.2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,68,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,71,(unur_tabl_set_nstp( par, 30 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,71,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,74,(unur_tabl_set_slopes( par, slopes, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,74,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,77,(unur_tabl_set_boundary( par, 0.,1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,77,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,80,(unur_tabl_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,80,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,83,(unur_tabl_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,83,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,86,(unur_tabl_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,86,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,89,(unur_tabl_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,92,(unur_tabl_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,92,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,95,(unur_tabl_set_variant_ia( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   double slopes[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,105,(unur_tabl_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,105,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,108,(unur_tabl_set_useear( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,108,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,111,(unur_tabl_set_usedars( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,111,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,114,(unur_tabl_set_darsfactor( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,114,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,117,(unur_tabl_set_variant_splitmode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,117,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,120,(unur_tabl_set_areafraction( par, 0.2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,120,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,123,(unur_tabl_set_nstp( par, 30 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,123,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,126,(unur_tabl_set_slopes( par, slopes, 2 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,126,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,129,(unur_tabl_set_boundary( par, 0.,1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,129,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,132,(unur_tabl_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,132,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,135,(unur_tabl_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,135,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,138,(unur_tabl_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,138,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,141,(unur_tabl_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,141,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,144,(unur_tabl_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,144,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,147,(unur_tabl_set_variant_ia( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,147,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double slopesA[4] = {0.,1.,0.5,2.};
   double slopesB[4] = {1.,2.,0.,1.};
   double stp[] = {1.,0.,1.};
   int n_stp = 3;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_tabl_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,162,(unur_tabl_set_cpoints( par, -1, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,162,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,165,(unur_tabl_set_cpoints( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,165,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,168,(unur_tabl_set_variant_splitmode( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,168,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,171,(unur_tabl_set_variant_splitmode( par, 4 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,171,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,174,(unur_tabl_set_areafraction( par, -0.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,174,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,177,(unur_tabl_set_nstp( par, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,177,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,180,(unur_tabl_set_slopes( par, slopesA, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,180,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,183,(unur_tabl_set_slopes( par, slopesA, 4 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,183,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,186,(unur_tabl_set_slopes( par, slopesB, 4 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,186,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,189,(unur_tabl_set_boundary( par, 2., 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,189,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,192,(unur_tabl_set_boundary( par, 0., UNUR_INFINITY )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,192,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,195,(unur_tabl_set_boundary( par, -UNUR_INFINITY, 0. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,195,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,198,(unur_tabl_set_guidefactor( par, -0.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,198,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,201,(unur_tabl_set_max_sqhratio( par, -0.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,201,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,204,(unur_tabl_set_max_sqhratio( par, 1.1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,204,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,207,(unur_tabl_set_max_intervals( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,207,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,219,(unur_tabl_get_sqhratio(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,219,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,222,(unur_tabl_get_hatarea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,222,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,225,(unur_tabl_get_squeezearea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,225,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,228,(unur_tabl_get_n_intervals(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,228,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 233,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,237,(unur_tabl_get_sqhratio(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,237,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,240,(unur_tabl_get_hatarea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,240,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,243,(unur_tabl_get_squeezearea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,243,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_zero(TESTLOG,246,(unur_tabl_get_n_intervals(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,246,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 257,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,261,(unur_tabl_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,261,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,272,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,272,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* wrong mode */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0);
   par = NULL; 


unur_reset_errno();
unur_distr_cont_set_mode(distr,-1.);
par = unur_tabl_new(distr);
n_tests_failed += (check_expected_NULL(TESTLOG,281,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,281,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_mode(distr,1.);
par = unur_tabl_new(distr);
n_tests_failed += (check_expected_NULL(TESTLOG,286,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,286,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* negative value of pdf */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_cont_new(); 
   unur_distr_cont_set_pdf(distr,pdf_negative);
   par = NULL; 


unur_reset_errno();
par = unur_tabl_new(distr);
n_tests_failed += (check_expected_NULL(TESTLOG,295,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,295,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_domain(distr,-2.,2.);
par = unur_tabl_new(distr);
n_tests_failed += (check_expected_NULL(TESTLOG,300,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,300,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tabl_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 309,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,313,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,313,UNUR_ERR_NO_REINIT)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,316,(unur_sample_cont( gen )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,316,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL; 


unur_reset_errno();
par = unur_tabl_new(distr);
n_tests_failed += (compare_sequence_par_start(TESTLOG,328,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
par = unur_tabl_new(distr);
unur_tabl_set_verify(par,1);
n_tests_failed += (compare_sequence_par(TESTLOG,333,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
par = unur_tabl_new(distr);
unur_tabl_set_variant_ia(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,338,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
par = unur_tabl_new(distr);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_verify(par,1);
n_tests_failed += (compare_sequence_par(TESTLOG,344,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_tabl_new(distr);
unur_tabl_set_max_sqhratio(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,358,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,364,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {3.,3.};
   double slopes[] = {0.5,-1,0.5,1};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_beta(fpar,2);
par = unur_tabl_new(distr);
unur_tabl_set_areafraction(par,0.25);
unur_tabl_set_boundary(par,0.1,0.9);
unur_tabl_set_guidefactor(par,5.);
unur_tabl_set_max_intervals(par,50);
unur_tabl_set_max_sqhratio(par,0.8);
unur_tabl_set_nstp(par,30);
unur_tabl_set_usedars(par,0);
unur_tabl_set_variant_splitmode(par,3);
unur_tabl_set_verify(par,TRUE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,387,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "beta(3.,3.) & \
   method = tabl; areafraction = 0.25; boundary = (0.1,0.9); \
   guidefactor = 5; max_intervals = 50; max_sqhratio = 0.8; \
   nstp = 30; usedars = 0; variant_splitmode = 3; verify" );
n_tests_failed += (compare_sequence_gen(TESTLOG,395,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_beta(fpar,2);
par = unur_tabl_new(distr);
unur_tabl_set_slopes(par,slopes,2);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,403,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "beta(3.,3.) & \
   method = tabl; slopes = (0.5,-1,0.5,1),2 " );
n_tests_failed += (compare_sequence_gen(TESTLOG,409,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_beta(fpar,2);
par = unur_tabl_new(distr);
unur_tabl_set_usedars(par,TRUE);
unur_tabl_set_darsfactor(par,0.5);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,418,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "beta(3.,3.) & method = tabl; usedars=on; darsfactor=0.5" );
n_tests_failed += (compare_sequence_gen(TESTLOG,423,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[31];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 31 */
{
fpm[0] = 1.;
fpm[1] = 2.;
distr[0] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 5.;
distr[1] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 100.;
distr[2] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[3] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 100.;
distr[4] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 500.;
fpm[1] = 300.;
distr[5] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = -3.;
fpm[3] = 15.;
distr[6] = unur_distr_beta(fpm,4);
}

{
distr[7] = unur_distr_cauchy(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[8] = unur_distr_cauchy(fpm,2);
}

{
distr[23] = unur_distr_exponential(NULL,0);
}

{
fpm[0] = 30.;
fpm[1] = -5.;
distr[24] = unur_distr_exponential(fpm,2);
}

{
fpm[0] = 1.;
distr[9] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 2.;
distr[10] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 3.;
distr[11] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 10.;
distr[12] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 1000.;
distr[13] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 5.;
fpm[1] = 1000.;
distr[14] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 1.e-5;
distr[15] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = 1000;
distr[16] = unur_distr_gamma(fpm,3);
}

{
distr[25] = unur_distr_laplace(NULL,0);
}

{
fpm[0] = -10.;
fpm[1] = 100.;
distr[26] = unur_distr_laplace(fpm,2);
}

{
distr[17] = unur_distr_normal(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 1.e-5;
distr[18] = unur_distr_normal(fpm,2);
}

{
fpm[0] = 0.;
fpm[1] = 1.e+5;
distr[19] = unur_distr_normal(fpm,2);
}

{
distr[20] = unur_distr_uniform(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[21] = unur_distr_uniform(fpm,2);
}

{
distr[22] = unur_distr_cauchy(NULL,0);
unur_distr_cont_set_domain(distr[22],0.1,1.);
unur_distr_cont_upd_mode(distr[22]);
unur_distr_cont_upd_pdfarea(distr[22]);
}

{
{ double domain[2] = {0., 3.};
distr[27] = unur_distr_sawtooth_contpdf(domain, 2); }
}

{
{ double domain[2] = {0., 5.};
distr[28] = unur_distr_sawtooth_contpdf(domain, 2); }
}

{
{ double domain[2] = {0., 3.};
distr[29] = unur_distr_sawtooth_discpdf(domain, 2); }
}

{
{ double domain[2] = {-2., 2.};
distr[30] = unur_distr_sawtooth_discpdf(domain, 2); }
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 310 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [24] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [26] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [30] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) {
unur_tabl_chg_truncated(gen,0.5,0.9);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{double slopes[6] = {1.,0.,2.,1.,3.,2.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,3);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{double slopes[8] = {-2.,-1.,-1.,0.,1.,0.,2.,1.};
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_slopes(par,slopes,4);}
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_tabl_new(distr_localcopy);
unur_tabl_set_variant_ia(par,FALSE);
unur_tabl_set_usedars(par,FALSE);
unur_tabl_set_useear(par,FALSE);
unur_use_urng_aux_default(par);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));

	printf("\n(verify hat) "); fflush(stdout);

/* verify hat tests: 310 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nVerify Hat Test (squeeze <= PDF <= hat):\n");

/* distribution [0] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[0],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[1],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[2],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[3],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[4],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[5],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[6],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[7],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[8],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[23],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [24] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[24],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[9],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[10],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[11],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[12],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[13],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[14],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[15],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[16],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [25] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[25],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [26] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[26],'-')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[17],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[18],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[19],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[20],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[21],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,TRUE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_usedars(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_variant_ia(par,FALSE);
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double slopes[4] = {0.,-0.5,0.,2.};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_slopes(par,slopes,2);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[22],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [27] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{double cpoints[] = {0.,0.5,1.0,1.5,2.0,2.5,3.0};
par = unur_tabl_new(distr_localcopy);
	unur_tabl_set_pedantic(par,0);
unur_tabl_set_cpoints(par,7,cpoints);}
	gen = unur_init(par);
	if (gen) unur_tabl_chg_verify(gen,1);
	n_tests_failed += (run_validate_verifyhat(TESTLOG,0,gen,distr[27],'~')==UNUR_SUCCESS)?0:1000;
	unur_free(gen);

	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [28] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [29] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [30] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_tabl_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_tabl_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_tabl_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 168382;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 168382;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("tabl: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_init();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

