#!/usr/local/bin/perl
# list_addresses.cgi
# Display contents of the user's address book

require './mailbox-lib.pl';
&ReadParse();
&header($text{'address_title'}, "");
print "<hr>\n";

@addrs = &list_addresses();
if (@addrs || $in{'add'}) {
	print "$text{'address_desc'}<p>\n";
	if ($in{'add'} || $in{'edit'} ne '') {
		print "<form action=save_address.cgi>\n";
		print "<input type=hidden name=add value='$in{'add'}'>\n";
		print "<input type=hidden name=edit value='$in{'edit'}'>\n";
		}
	print "<table>\n";
	print "<tr> <td colspan=2></td> <td><b>$text{'address_addr'}</b></td> ",
	      "<td><b>$text{'address_name'}</b></td> ",
	      $config{'edit_from'} ? "<td><b>$text{'address_from'}</b></td> " : "",
	      "</tr>\n";
	foreach $a (@addrs) {
		next if (!defined($a->[2]));
		print "<tr> <td>\n";
		if ($in{'edit'} ne $a->[2]) {
			print "<a href='list_addresses.cgi?edit=$a->[2]'>",
			      "$text{'address_edit'}</a>\n";
			}
		print "</td> <td>\n";
		print "<a href='save_address.cgi?delete=$a->[2]'>",
		      "$text{'address_delete'}</a></td>\n";

		if ($in{'edit'} eq $a->[2]) {
			print "<td><input name=addr size=30 value='",
				&html_escape($a->[0]),"'></td>\n";
			print "<td><input name=name size=30 value='",
				&html_escape($a->[1]),"'></td>\n";
			if ($config{'edit_from'}) {
				&from_sel($a->[3]);
				}
			else {
				print "<input type=hidden name=from value='$a->[3]'>\n";
				}
			print "<td><input type=submit value='$text{'save'}'></td>\n";
			}
		else {
			print "<td>$a->[0]</td>\n";
			print "<td>",$a->[1] ? $a->[1] : "<br>","</td>\n";
			print "<td>",$a->[3] == 1 ? $text{'yes'} :
				     $a->[3] == 2 ? $text{'address_yd'} :
					     	    $text{'no'},"</td>\n"
				if ($config{'edit_from'});
			}
		print "</tr>\n";
		}
	if ($in{'add'}) {
		print "<tr> <td colspan=2></td>\n";
		print "<td><input name=addr size=30></td>\n";
		print "<td><input name=name size=30></td>\n";
		print &from_sel() if ($config{'edit_from'});
		print "<td><input type=submit value='$text{'save'}'></td>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>$text{'address_none'}</b> <p>\n";
	}
print "<a href='list_addresses.cgi?add=1'>$text{'address_add'}</a> <br>\n"
	if (!$in{'add'});

print "<hr>\n";
&footer("", $text{'mail_return'});

sub from_sel
{
print "<td><select name=from>\n";
printf "<option value=0 %s> %s\n",
	$_[0] == 0 ? "selected" : "", $text{'no'};
printf "<option value=1 %s> %s\n",
	$_[0] == 1 ? "selected" : "", $text{'yes'};
printf "<option value=2 %s> %s\n",
	$_[0] == 2 ? "selected" : "", $text{'address_yd'};
print "</select></td>\n";
}

