#!/usr/local/bin/perl
# edit_dbase.cgi
# Show database tables

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
&header($text{'dbase_title'}, "", "edit_dbase");
print "<center><font size=+2><tt>$in{'db'}</tt></font></center>\n";
@titles = &list_tables($in{'db'});
print "<hr>\n";

if (@titles) {
	print "<h3>$text{'dbase_tables'}</h3>\n";
	@icons = map { "images/table.gif" } @titles;
	@links = map { "edit_table.cgi?db=$in{'db'}&table=$_" } @titles;
	&show_buttons();
	if ($config{'style'}) {
		foreach $t (@titles) {
			local $c = &execute_sql($in{'db'},
						"select count(*) from $t");
			push(@rows, $c->{'data'}->[0]->[0]);
			local @str = &table_structure($in{'db'}, $t);
			push(@fields, scalar(@str));
			}
		@titles = map { &html_escape($_) } @titles;
		&split_table([ $text{'dbase_table'}, $text{'dbase_rows'},
			       $text{'dbase_cols'} ], \@links, \@titles,
			     \@rows, \@fields) if (@titles);
		}
	else {
		@titles = map { &html_escape($_) } @titles;
		&icons_table(\@links, \@titles, \@icons, 5);
		}
	}
else {
	print "<b>$text{'dbase_none'}</b> <p>\n";
	}
&show_buttons();

print "<hr>\n";
&footer("", $text{'index_return'});

sub show_buttons
{
if (!$access{'edonly'}) {
	$count = 2;
	$count++ if ($access{'delete'});
	$count++ if ($access{'buser'});
	$pct = int(100/$count);

	print "<table width=100%> <tr>\n";
	print "<form action=table_form.cgi>\n";
	print "<input type=hidden name=db value='$in{'db'}'>\n";
	print "<td width=$pct% nowrap><input type=submit ",
	      "value='$text{'dbase_add'}'>\n";
	print $text{'dbase_fields'},"\n";
	print "<input name=fields size=4 value='4'></td>\n";
	print "</form>\n";
	if ($access{'delete'}) {
		print "<form action=drop_dbase.cgi>\n";
		print "<input type=hidden name=db value='$in{'db'}'>\n";
		print "<td align=middle width=$pct%><input type=submit ",
		      "value='$text{'dbase_drop'}'></td></form>\n";
		}

	if ($access{'buser'}) {
		print "<form action=backup_form.cgi>\n";
		print "<input type=hidden name=db value='$in{'db'}'>\n";
		print "<td align=middle width=$pct%><input type=submit ",
		      "value='$text{'dbase_backup'}'></td></form>\n";
		}

	print "<form action=exec_form.cgi>\n";
	print "<input type=hidden name=db value='$in{'db'}'>\n";
	print "<td align=right width=$pct%><input type=submit ",
	      "value='$text{'dbase_exec'}'></td>\n";
	print "</form>\n";
	print "</tr> </table></form>\n";
	}
}

