#!/usr/local/bin/perl
# download.cgi
# Save a download or start it right now

require './updown-lib.pl';
require 'timelocal.pl';
&ReadParse();
&error_setup($text{'download_err'});

# Validate and store inputs
$i = 0;
@urls = split(/[\r\n]+/, $in{'urls'});
foreach $u (@urls) {
	local ($proto, $host, $port, $page, $ssl);
	if ($u =~ /^(http|https):\/\/([^\/]+)(\/.*)$/) {
		$proto = "http";
		$ssl = $1 eq 'https';
		$host = $2; $page = $3; $port = $ssl ? 443 : 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		}
	elsif ($u =~ /^ftp:\/\/([^\/]+)(:21)?(\/.*)$/) {
		$proto = "ftp";
		$host = $1; $page = $3;
		}
	else {
		&error(&text('download_eurl', $u));
		}
	$download{"url_$i"} = $u;
	$download{"proto_$i"} = $proto;
	$download{"host_$i"} = $host;
	$download{"port_$i"} = $port;
	$download{"page_$i"} = $page;
	$download{"ssl_$i"} = $ssl;
	$i++;
	}
$in{'dir'} || &error($text{'upload_edir'});
&can_write_file($in{'dir'}) ||
	&error(&text('download_eaccess', "<tt>$in{'dir'}</tt>", $!));
$download{'dir'} = $in{'dir'};
if (!$module_info{'usermin'}) {
	defined(@uinfo = getpwnam($in{'user'})) || &error($text{'upload_euser'});
	$download{'uid'} = $uinfo[2];
	$in{'group_def'} || defined(@ginfo = getgrnam($in{'group'})) ||
		&error($text{'upload_egroup'});
	$download{'gid'} = defined(@ginfo) ? $ginfo[2] : $uinfo[3];
	}
if ($in{'bg'} && !$module_info{'usermin'}) {
	# Validate time
	$in{'hour'} =~ /^\d+$/ && $in{'min'} =~ /^\d+$/ &&
		$in{'day'} =~ /^\d+$/ && $in{'year'} =~ /^\d+$/ ||
			&error($text{'download_edate'});
	eval { $download{'time'} = timelocal(0, $in{'min'}, $in{'hour'},
			 $in{'day'}, $in{'month'}, $in{'year'}-1900) };
	$@ && &error($text{'download_edate2'});
	}

# Create the directory if needed
if (!-d $download{'dir'} && $in{'mkdir'}) {
	mkdir($download{'dir'}, 0755) || &error(&text('upload_emkdir', $!));
	chown($download{'uid'}, $download{'gid'}, $download{'dir'})
		if (!$module_info{'usermin'});
	}

# Save the settings
$config = $user_module_config_directory || $module_config_directory;
&lock_file("$config/config");
$config{'ddir'} = $in{'dir'};
$config{'duser'} = $in{'user'};
$config{'dgroup'} = $in{'group_def'} ? undef : $in{'group'};
&write_file("$config/config", \%config);
&unlock_file("$config/config");

if ($in{'bg'}) {
	# Create a script to be called by At
	open(PERL, "$config_directory/perl-path");
	chop($perl_path = <PERL>);
	close(PERL);
	&lock_file($atjob_cmd);
	open(CMD, ">$atjob_cmd");
	print CMD <<EOF;
#!$perl_path
open(CONF, "$config_directory/miniserv.conf");
while(<CONF>) {
	\$root = \$1 if (/^root=(.*)/);
	}
close(CONF);
\$ENV{'WEBMIN_CONFIG'} = "$ENV{'WEBMIN_CONFIG'}";
\$ENV{'WEBMIN_VAR'} = "$ENV{'WEBMIN_VAR'}";
chdir("\$root/$module_name");
exec("\$root/$module_name/download.pl", \$ARGV[0]);
EOF
	close(CMD);
	chmod(0755, $atjob_cmd);
	&unlock_file($atjob_cmd);
	&save_download(\%download);

	if ($module_info{'usermin'} || !&foreign_check("at")) {
		# Just run this script right now
		system("$atjob_cmd $download{'id'} >/dev/null 2>&1 </dev/null &");
		}
	else {
		# Create an At job to do the download
		&foreign_require("at", "at-lib.pl");
			{
			local %ENV;
			delete($ENV{'FOREIGN_MODULE_NAME'});
			delete($ENV{'FOREIGN_ROOT_DIRECTORY'});
			&clean_environment();
			$ENV{'REMOTE_USER'} = $remote_user;	# For usermin
			$ENV{'BASE_REMOTE_USER'} = $base_remote_user;
			local $au = $module_info{'usermin'} ? $remote_user
							    : "root";
			&at::create_atjob($au, $download{'time'},
					  "$atjob_cmd $download{'id'}", "/");
			&reset_environment();
			}
		}

	&redirect("");
	}
else {
	# Download it now, and show the results
	$| = 1;
	$theme_no_table = 1;
	&header($text{'download_title'}, "");
	print "<hr>\n";
	$error = &do_download(\%download, \&progress_callback, \@paths);
	@paths = grep { $_ } @paths;
	if (@paths) {
		print "<p>$text{'download_done'}<p>\n";
		foreach $p (@paths) {
			@st = stat($p);
			print "<tt>$p</tt> ($st[7] bytes)<br>\n";
			}
		}
	if ($error) {
		print "<p><b>",&text('download_failed', $error),"</b><p>\n";
		}
	print "<hr>\n";
	&footer("", $text{'index_return'});
	}
&webmin_log("download", undef, undef, { 'urls' => \@urls,
					'time' => $download{'time'} });

