#!/usr/local/bin/perl
# index.cgi
# Display scheduled downloads, plus a form for uploading a file

require './updown-lib.pl';
&header($text{'index_title'}, "", undef, 0, 1);
print "<hr>\n";

# Show form for downloading
$form = 0;
print "<form action=download.cgi method=post>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_header1'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td valign=top><b>$text{'index_urls'}</b></td>\n";
print "<td colspan=3><textarea name=urls rows=4 cols=70 wrap=off>",
      "</textarea></td> </tr>\n";

$ddir = $userconfig{'ddir'} || $config{'ddir'};
$ddir = $remote_user_info[7] if ($ddir eq "~");
print "<tr> <td><b>$text{'index_ddir'}</b></td>\n";
print "<td colspan=3><input name=dir size=50 value='$ddir'> ",
	&file_chooser_button("dir", 1, 0);
print "<input type=checkbox name=mkdir value=1> $text{'index_mkdir'}\n";
print "</td> </tr>\n";

if (!$module_info{'usermin'} && &foreign_check("at")) {
	# Webmin users can select a username and choose scheduled download time
	print "<tr> <td><b>$text{'index_user'}</b></td>\n";
	print "<td>",&unix_user_input("user", $config{'duser'}, $form),
	      "</td>\n";

	print "<td><b>$text{'index_group'}</b></td>\n";
	printf "<td><input type=radio name=group_def value=1 %s> %s\n",
		$config{'dgroup'} ? "" : "checked", $text{'default'};
	printf "<input type=radio name=group_def value=0 %s>\n",
		$config{'dgroup'} ? "checked" : "";
	printf &unix_group_input("group", $config{'dgroup'}, $form),
	       "</td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'index_bg'}</b></td> <td colspan=3>\n";
	print "<input type=radio name=bg value=0 checked> $text{'index_bg0'}<br>\n";
	print "<input type=radio name=bg value=1> $text{'index_bg1'}\n";

	@now = localtime(time());
	printf "<input name=day size=2 value='%d'>/", $now[3];
	print "<select name=month>\n";
	for($i=0; $i<12; $i++) {
		printf "<option value=%s %s>%s\n",
			$i, $now[4] == $i ? 'selected' : '', $text{"smonth_".($i+1)};
		}
	print "</select>/";
	printf "<input name=year size=4 value='%d'>\n", $now[5] + 1900;
	print &date_chooser_button("day", "month", "year", $form),"\n";

	print "$text{'index_time'}\n";
	printf "<input name=hour size=2 value='%2.2d'>:<input name=min size=2 value='%2.2d'></td> </tr>\n", $now[2], $now[1];
	}
else {
	# Usermin users can only choose to download now or in the background
	# immediately
	print "<tr> <td valign=top><b>$text{'index_bg'}</b></td> <td colspan=3>\n";
	print "<input type=radio name=bg value=0 checked> $text{'index_bg0'}<br>\n";
	print "<input type=radio name=bg value=1> $text{'index_bg1u'}\n";
	}

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'index_down'}'></form>\n";

# Show current list of scheduled or active downloads
@downs = &list_downloads();
if (@downs) {
	$form++;
	local ($notdone) = grep { !$_->{'complete'} } @downs;
	print "<form action=cancel.cgi>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> ",
	      $notdone ? "<td><br></td>" : "",
	      "<td><b>$text{'index_urls'}</b></td> ",
	      "<td><b>$text{'index_dest'}</b></td> ",
	      "<td><b>$text{'index_when'}</b></td> ",
	      "<td><b>$text{'index_prog'}</b></td> </tr>\n";
	foreach $d (@downs) {
		print "<tr $cb>\n";
		if (!$d->{'complete'}) {
			printf "<td valign=top width=5><input type=checkbox ".
			       "name=cancel value=%s></td>\n", $d->{'id'};
			}
		elsif ($notdone) {
			print "<td width=5><br></td>\n";
			}
		print "<td valign=top>\n";
		local $count = 0;
		while($url = $d->{"url_$count"}) {
			print "<br>\n" if ($count);
			if (length($url) > 70 && $url =~ /^([^:]+:\/\/[^\/]+\/)(.*)(\/[^\/]+)$/) {
				print "$1 .. $3";
				}
			else {
				print $url;
				}
			$count++;
			}
		print "</td>\n";
		printf "<td valign=top>%s</td>\n", $d->{'dir'};
		print "<td valign=top nowrap>",
			$d->{'time'} ? &make_date($d->{'time'})
				     : $text{'index_imm'},"</td>\n";
		print "<td valign=top nowrap>";
		if (!defined($d->{'upto'})) {
			print $text{'index_noprog'};
			}
		elsif ($d->{'error'}) {
			print "<font color=#ff0000>$d->{'error'}</font>\n";
			&delete_download($d);
			}
		elsif ($d->{'complete'}) {
			print "<font color=#00ff00>$text{'index_done'} (",
				&simplify($d->{'total'}),")</font>\n";
			&delete_download($d);
			}
		else {
			if ($count > 1) {
				print &text('index_upto', $d->{'upto'}+1,
							  $count),"\n";
				}
			local $sz = &simplify($d->{'got'});
			print "$sz\n";
			if ($d->{'size'}) {
				print "(".int($d->{'got'}*100/$d->{'size'}).
				      "%)\n";
				}
			}
		print "</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	print "<input type=submit value='$text{'index_cancel'}'>\n"
		if ($notdone);
	print "</form>\n";
	}

print "<hr>\n";

# Show form for uploading
$form++;
print "<form action=upload.cgi method=post enctype=multipart/form-data>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_header2'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td valign=top><b>$text{'index_upload'}</b></td>\n";
print "<td colspan=3>\n";
for($i=0; $i<4; $i++) {
	print "<input name=upload$i type=file>\n";
	print "<br>\n" if ($i%2 == 1);
	}
print "</td> </tr>\n";

$dir = $userconfig{'dir'} || $config{'dir'};
$dir = $remote_user_info[7] if ($dir eq "~");
print "<tr> <td><b>$text{'index_dir'}</b></td>\n";
print "<td colspan=3><input name=dir size=50 value='$dir'> ",
	&file_chooser_button("dir", 1, $form);
print "<input type=checkbox name=mkdir value=1> $text{'index_mkdir'}\n";
print "</td> </tr>\n";

if (!$module_info{'usermin'}) {
	print "<tr> <td><b>$text{'index_user'}</b></td>\n";
	print "<td>",&unix_user_input("user", $config{'user'}, $form),"</td>\n";

	print "<td><b>$text{'index_group'}</b></td>\n";
	printf "<td><input type=radio name=group_def value=1 %s> %s\n",
		$config{'group'} ? "" : "checked", $text{'default'};
	printf "<input type=radio name=group_def value=0 %s>\n",
		$config{'group'} ? "checked" : "";
	printf &unix_group_input("group", $config{'group'}, $form),
	       "</td> </tr>\n";
	}

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'index_ok'}'></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

sub simplify
{
if ($_[0] > 1000000) {
	return int($_[0]/1000000)." MB";
	}
elsif ($_[0] > 1000) {
	return int($_[0]/1000)." kB";
	}
else {
	return int($_[0])." bytes";
	}
}

