#!/usr/local/bin/perl
# upload.cgi
# Upload multiple files

require './updown-lib.pl';
&ReadParseMime();
&error_setup($text{'upload_err'});

# Validate inputs
$in{'dir'} || &error($text{'upload_edir'});
if (!$module_info{'usermin'}) {
	defined(@uinfo = getpwnam($in{'user'})) ||
		&error($text{'upload_euser'});
	$in{'group_def'} || defined(@ginfo = getgrnam($in{'group'})) ||
		&error($text{'upload_egroup'});
	}
for($i=0; defined($d = $in{"upload$i"}); $i++) {
	$f = $in{"upload${i}_filename"};
	$found++ if ($d && $f);
	}
$found || &error($text{'upload_enone'});
&can_write_file($in{'dir'}) ||
	&error(&text('upload_eaccess', "<tt>$in{'dir'}</tt>", $!));

# Create the directory if needed
$uid = $uinfo[2];
$gid = defined(@ginfo) ? $ginfo[2] : $uinfo[3];
if (!-d $in{'dir'} && $in{'mkdir'}) {
	mkdir($in{'dir'}, 0755) || &error(&text('upload_emkdir', $!));
	chown($uid, $gid, $in{'dir'}) if (!$module_info{'usermin'});
	}

# Do the files
for($i=0; defined($d = $in{"upload$i"}); $i++) {
	$f = $in{"upload${i}_filename"};
	next if (!$d || !$f);
	if (-d $in{'dir'}) {
		$f =~ /([^\\\/]+)$/;
		$path = "$in{'dir'}/$1";
		}
	else {
		$path = $in{'dir'};
		}
	if (!open(FILE, ">$path")) {
		&error(&text('upload_eopen', "<tt>$path</tt>", $!));
		}
	print FILE $d;
	close(FILE);
	chown($uid, $gid, $path);
	push(@uploads, $path);
	}

&header($text{'upload_title'}, "");
print "<hr>\n";

print "<p>$text{'upload_done'}<p>\n";
foreach $u (@uploads) {
	@st = stat($u);
	print "<tt>$u</tt> ($st[7] bytes)<br>\n";
	}
print "<p>\n";

# Save the settings
$config = $user_module_config_directory || $module_config_directory;
&lock_file("$config/config");
$config{'dir'} = $in{'dir'};
$config{'user'} = $in{'user'};
$config{'group'} = $in{'group_def'} ? undef : $in{'group'};
&write_file("$config/config", \%config);
&unlock_file("$config/config");

&webmin_log("upload", undef, undef, { 'uploads' => \@uploads });

print "<hr>\n";
&footer("", $text{'index_return'});

