#!/usr/local/bin/perl
# index.cgi
# Display a list of all cron jobs, with the username and command for each one

require './cron-lib.pl';

&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";
map { $ucan{$_}++ } split(/\s+/, $access{'users'});
@jobs = &list_cron_jobs();
@ulist = &unique(map { $_->{'user'} } @jobs);
if ($access{'mode'} == 1) {
	@ulist = grep { $ucan{$_} } @ulist;
	}
elsif ($access{'mode'} == 2) {
	@ulist = grep { !$ucan{$_} } @ulist;
	}
elsif ($access{'mode'} == 3) {
	@ulist = ( $remote_user );
	}
elsif ($access{'mode'} == 4) {
	@ulist = grep { local @u = getpwnam($_);
			(!$access{'uidmin'} || $u[2] >= $access{'uidmin'}) &&
			(!$access{'uidmax'} || $u[2] <= $access{'uidmax'}) }
		      @ulist;
	}
elsif ($access{'mode'} == 5) {
	@ulist = grep { local @u = getpwnam($_);
			$u[3] == $access{'users'} } @ulist;
	}
foreach $u (@ulist) {
	if ((@uinfo = getpwnam($u)) && $uinfo[5] =~ /\S/) {
		$uname = "$u ($uinfo[5])";
		}
	else { $uname = $u; }

	@jlist = grep { $_->{'user'} eq $u } @jobs;
	@plist = ();
	for($i=0; $i<@jlist; $i++) {
		local $rpd = &is_run_parts($jlist[$i]->{'command'});
		local @exp = $rpd ? &expand_run_parts($rpd) : ();
		if (!$rpd || @exp) {
			push(@plist, [ $jlist[$i], \@exp ]);
			}
		}
	for($i=0; $i<@plist; $i++) {
		local $job = $plist[$i]->[0];
		local @exp = @{$plist[$i]->[1]};
		local $idx = $job->{'index'};
		if (!$donehead) {
			print "<a href=\"edit_cron.cgi?new=1\">$text{'index_create'}</a>\n";
			print "<a href=\"edit_env.cgi?new=1\">$text{'index_ecreate'}</a>\n" if ($env_support);
			print "<br>\n";
			print "<table border width=100%> <tr $tb>\n";
			if (@ulist != 1 || $access{'mode'} != 3) {
				print "<td><b>$text{'index_user'}</b></td>\n";
				}
			print "<td><b>$text{'index_active'}</b></td>\n";
			print "<td><b>$text{'index_command'}</b></td>\n";
			print "<td width=5%><b>$text{'index_move'}</b></td> </tr>\n";
			$donehead = 1;
			}
		print "<tr $cb>\n";
		if ($i == 0 && (@ulist != 1 || $access{'mode'} != 3)) {
			printf "<td valign=top rowspan=%d>", scalar(@plist);
			print &html_escape($uname);
			print "</td>\n";
			}
		printf "<td valign=top>%s</td>\n",
			$job->{'active'} ? $text{'yes'}
				: "<font color=#ff0000>$text{'no'}</font>";
		if ($job->{'name'}) {
			print "<td><a href=\"edit_env.cgi?idx=$idx\">",
			      "<i>$text{'index_env'}</i> ",
			     "<tt>$job->{'name'} = $job->{'value'}</tt></td>\n";
			}
		elsif (@exp) {
			@exp = map { &html_escape($_) } @exp;
			print "<td><a href=\"edit_cron.cgi?idx=$idx\">",
			      join("<br>",@exp),"</a></td>\n";
			}
		else {
			local $max = $config{'max_len'} || 10000;
			local $cmd = $job->{'command'};
			$cmd =~ s/\\%/\0/g; $cmd =~ s/%.*$//;
			$cmd =~ s/\0/%/g;
			printf "<td><a href=\"edit_cron.cgi?idx=$idx\">".
			       "%s</a>%s</td>\n",
				length($cmd) > $max ?
					&html_escape(substr($cmd, 0, $max)) :
				$cmd !~ /\S/ ? "BLANK" : &html_escape($cmd),
				length($cmd) > $max ? " ..." : "";
			}

		local $prv = $i > 0 ? $plist[$i-1]->[0] : undef;
		local $nxt = $i != $#plist ? $plist[$i+1]->[0] : undef;
		print "<td width=5%>";
		if ($prv && $prv->{'file'} eq $job->{'file'} &&
		    $job->{'type'} == 0) {
			print "<a href='move.cgi?idx=$idx&up=1'>",
			      "<img src=images/up.gif border=0></a>";
			}
		else {
			print "<img src=images/gap.gif>";
			}
		if ($nxt && $nxt->{'file'} eq $job->{'file'} &&
		    $job->{'type'} == 0) {
			print "<a href='move.cgi?idx=$idx&down=1'>",
			      "<img src=images/down.gif border=0></a>";
			}
		else {
			print "<img src=images/gap.gif>";
			}
		print "</td> </tr>\n";
		}
	}
if ($donehead) {
	print "</table>\n";
	}
else {
	print $access{'mode'} ? "<b>$text{'index_none2'}</b> <p>\n"
			      : "<b>$text{'index_none'}</b> <p>\n";
	}
print "<a href=\"edit_cron.cgi?new=1\">$text{'index_create'}</a>\n";
print "<a href=\"edit_env.cgi?new=1\">$text{'index_ecreate'}</a>\n"
	if ($env_support);
print "<p>\n";

if ($config{cron_allow_file} && $config{cron_deny_file} && $access{'allow'}) {
	print "<h3><a href=edit_allow.cgi>$text{'index_allow'}</a></h3>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

