#!/usr/local/bin/perl
# index.cgi
# Display a table of all filesystems that can be mounted/unmounted by
# a user, due to having the user flag set

require './usermount-lib.pl';
&header($text{'index_title'}, "", undef, 0, 1);
print "<hr>\n";

@mounts = &list_mounts();
foreach $m (@mounts) {
	local %options;
	&parse_options($m->[2], $m->[3]);
	if (defined($options{'user'})) {
		push(@usermounts, $m);
		}
	}
foreach $m (&list_mounted()) {
	$mounted{$m->[0],$m->[1]}++;
	}
if (@usermounts) {
	print "<form action=mount.cgi>\n";
	print "<table width=100% border>\n";
	print "<tr $tb> <td><b>$text{'index_dir'}</b></td>\n",
	      "<td><b>$text{'index_type'}</b></td>\n",
	      "<td><b>$text{'index_dev'}</b></td>\n",
	      "<td><b>$text{'index_status'}</b></td>\n",
	      "<td><b>$text{'index_action'}</b></td> </tr>\n";
	foreach $u (@usermounts) {
		print "<tr $cb>\n";
		print "<td>$u->[0]</td>\n";
		local $fsn = &fstype_name($u->[2]);
		print "<td>",$u->[2] eq "*" ? $text{'index_auto'}
					    : $fsn,"</td>\n";
		print "<td>",&device_name($u->[1]),"</td>\n";
		if ($mounted{$u->[0],$u->[1]}) {
			print "<td>$text{'yes'}</td>\n";
			print "<td><input type=submit name='umount_$u->[0]' value='$text{'index_umount'}'></td>\n";
			}
		else {
			print "<td>$text{'no'}</td>\n";
			print "<td><input type=submit name='mount_$u->[0]' value='$text{'index_mount'}'></td>\n";
			}
		print "</tr>\n";
		}
	print "</table></form>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

