#!/usr/local/bin/perl
# check.pl
# Run fetchmail, and send the output somewhere

$no_acl_check++;
$ENV{'REMOTE_USER'} = getpwuid($<);
require './fetchmail-lib.pl';

# Parse command-line args
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--mail") {
		$mail = shift(@ARGV);
		}
	elsif ($a eq "--file") {
		$file = shift(@ARGV);
		}
	elsif ($a eq "--output") {
		$output = 1;
		}
	elsif ($a eq "--user") {
		$user = shift(@ARGV);
		}
	elsif ($a eq "--errors") {
		$errors = 1;
		}
	elsif ($a eq "--owner") {
		$owner = 1;
		}
	}

if ($fetchmail_config) {
	# Just run once for a single config file
	&run_fetchmail($fetchmail_config, $user);
	}
else {
	# Run for all users
	setpwent();
	while(@uinfo = getpwent()) {
		next if ($donehome{$uinfo[7]}++);
		@conf = &parse_config_file("$uinfo[7]/.fetchmailrc");
		@conf = grep { $_->{'poll'} } @conf;
		if (@conf) {
			&run_fetchmail("$uinfo[7]/.fetchmailrc", $uinfo[0]);
			}
		}
	endpwent();
	}

# run_fetchmail(config, user)
sub run_fetchmail
{
local ($config, $user) = @_;

# Build the command
local $cmd = "$config{'fetchmail_path'} -v -f ".quotemeta($config);
if ($config{'mda_command'}) {
	$cmd .= " -m ".quotemeta($config{'mda_command'});
	}
if ($user && $user ne "root") {
	$cmd = "su ".quotemeta($user)." -c ".quotemeta($cmd);
	}

# Run it
local $out = `($cmd) 2>&1 </dev/null`;

# Handle the output
if ($owner) {
	# Force mailing to user
	$mail = $user."\@".&get_system_hostname();
	}
if ($errors && $?/256 <= 1) {
	# No error occurred, so do nothing
	}
elsif ($file) {
	# Just write to a file
	open(FILE, ">$file");
	print FILE $out;
	close(FILE);
	}
elsif ($mail) {
	# Capture output and email
	$mm = $module_info{'usermin'} ? "mailbox" : "mailboxes";
	if (&foreign_check($mm)) {
		$fr = !$module_info{'usermin'} ?
			$user."\@".&get_system_hostname() :
			&foreign_call($mm, "get_from_address");
		&foreign_require($mm, "$mm-lib.pl");
		&foreign_require($mm, "boxes-lib.pl");
		$email = { 'headers' =>
				[ [ 'From', $fr ],
				  [ 'Subject', $?/256 <= 1 ? "Fetchmail output"
							   : "Fetchmail error"],
				  [ 'To', $mail ] ],
			  'attach'  => [ { 'headers' => [ [ 'Content-type',
							    'text/plain' ] ],
					   'data' => $out } ]
			};
		&foreign_call($mm, "send_mail", $email);
		}
	else {
		print "$mm module not installed - could not email the following output :\n";
		print $out;
		}
	}
elsif ($output) {
	# Output goes to cron
	print STDERR $out;
	}
else {
	# Just throw away output
	}
}

