#!/usr/local/bin/perl
# save_dir.cgi
# Create or update a .htaccess file

require './htaccess-lib.pl';
&ReadParse();
@dirs = &list_directories();
&error_setup($text{'dir_err'});
&foreign_require($apachemod, "apache-lib.pl");

# Work out what .htaccess file to use
if ($in{'new'} && $in{'dir'} !~ /^\// && $default_dir ne "/") {
	# Make path absolute
	$in{'dir'} = "$default_dir/$in{'dir'}";
	}
($dir) = grep { $_->[0] eq $in{'dir'} } @dirs;
if ($in{'new'}) {
	$dir && &error($text{'dir_eclash'});
	$htaccess = "$in{'dir'}/$config{'htaccess'}";
	}
else {
	$htaccess = "$dir->[0]/$config{'htaccess'}";
	}

&lock_file($htaccess);
&lock_file($directories_file);

# Get the apache directives for the .htaccess file, if any
$auf = $in{'crypt'} == 3 ? "AuthDigestFile" : "AuthUserFile";
$agf = $in{'crypt'} == 3 ? "AuthDigestGroupFile" : "AuthGroupFile";
$conf = &foreign_call($apachemod, "get_htaccess_config", $htaccess);
$currfile = &foreign_call($apachemod, "find_directive",
			  $auf, $conf, 1);
$currgfile = &foreign_call($apachemod, "find_directive",
			   $agf, $conf, 1);
&lock_file($currfile) if ($currfile);

# Make sure it is allowed
&switch_user();
&can_access_dir($htaccess) || &error($text{'dir_ecannot'});
&open_tempfile(TEST, ">>$htaccess", 1) || &error(&text('dir_ehtaccess', $htaccess, $!));
&close_tempfile(TEST);

if ($in{'delete'}) {
	if ($in{'remove'}) {
		# Blow away .htaccess, htpasswd and htgroups
		&unlink_logged($htaccess);
		&unlink_logged($currfile) if ($currfile);
		&unlink_logged($currgfile) if ($currgfile);
		@dirs = grep { $_ ne $dir } @dirs;
		}
	else {
		# Take the authentication directives out of the .htaccess
		@dirs = grep { $_ ne $dir } @dirs;
		&foreign_call($apachemod, "save_directive",
			      "require", [ ], $conf, $conf);
		}
	}
else {
	# Validate inputs
	if ($in{'new'}) {
		$in{'dir'} =~ /^\// && -d $in{'dir'} ||
			&error($text{'dir_edir'});
		}

	# Parse users file option
	if (!$can_htpasswd) {
		# Users file is always automatic
		$file = $in{'new'} ? "$in{'dir'}/$config{'htpasswd'}"
				   : $dir->[1];
		}
	elsif ($in{'auto'}) {
		# User choose for it to be automatic
		$file = "$in{'dir'}/$config{'htpasswd'}";
		}
	else {
		# Entered by user
		$in{'file'} || &error($text{'dir_efile'});
		if ($in{'file'} !~ /^\//) {
			$file = "$in{'dir'}/$in{'file'}";
			}
		else {
			$file = $in{'file'};
			}
		}

	# Parse groups file option
	if (!$can_htgroups) {
		# Groups file is always fixed, or none
		$gfile = $in{'new'} ? undef : $dir->[3];
		}
	elsif ($in{'gauto'} == 2) {
		# No groups file
		$gfile = undef;
		}
	elsif ($in{'gauto'} == 1) {
		# User choose for groups file to be automatic
		$gfile = "$in{'dir'}/$config{'htgroups'}";
		}
	else {
		# Groups file was entered by user
		$in{'file'} || &error($text{'dir_egfile'});
		if ($in{'gfile'} !~ /^\//) {
			$gfile = "$in{'dir'}/$in{'gfile'}";
			}
		else {
			$gfile = $in{'gfile'};
			}
		}

	# Parse require option
	@require = ( $in{'require_mode'} );
	if ($in{'require_mode'} eq "user") {
		@users = split(/\s+/, $in{'require_user'});
		@users || &error($text{'dir_erequire_user'});
		push(@require, @users);
		}
	elsif ($in{'require_mode'} eq "group") {
		@groups = split(/\s+/, $in{'require_group'});
		@groups || &error($text{'dir_erequire_group'});
		push(@require, @groups);
		}

	# Parse Webmin sync
	$sync = join(",", grep { $in{'sync_'.$_} }
			       ('create', 'update', 'delete'));
	$sync ||= "-";

	if ($in{'new'}) {
		# Either update an existing .htaccess to ensure that all
		# needed directives exist, or create from scratch

		# Use the existing users path if there is one, otherwise add
		$currfile = &foreign_call($apachemod, "find_directive",
					  $auf, $conf, 1);
		if ($currfile) {
			$file = $currfile;
			}
		else {
			&foreign_call($apachemod, "save_directive",
				      $auf, [ $file ], $conf, $conf);
			}

		# Use the existing groups path if there is one, otherwise add
		$currgfile = &foreign_call($apachemod, "find_directive",
					   $agf, $conf, 1);
		if ($currgfile) {
			$gfile = $currgfile;
			}
		elsif ($gfile) {
			&foreign_call($apachemod, "save_directive",
				      $agf, [ $gfile ], $conf,$conf);
			}

		# Add an auth type if needed
		$currtype = &foreign_call($apachemod, "find_directive",
					  "AuthType", $conf, 1);
		if (!$currtype) {
			&foreign_call($apachemod, "save_directive",
				     "AuthType",
				     [ $in{'crypt'} == 3 ? "Digest" : "Basic" ],
				     $conf, $conf);
			}

		# Add a realm if needed
		$currrealm = &foreign_call($apachemod, "find_directive",
					   "AuthName", $conf, 1);
		if (!$currrealm) {
			$in{'realm'} || &error($text{'dir_erealm'});
			&foreign_call($apachemod, "save_directive", "AuthName",
				      [ "\"$in{'realm'}\"" ], $conf, $conf);
			}

		# Add a require if needed
		$currrequire = &foreign_call($apachemod, "find_directive",
					     "require", $conf, 1);
		if (!$currrequire) {
			&foreign_call($apachemod, "save_directive",
				      "require", \@require,
						$conf, $conf);
			}

		# Add to the known directories list
		$sync = "-" if (!$can_sync);
		$dir = [ $in{'dir'}, $file, $in{'crypt'}, $sync, $gfile ];
		push(@dirs, $dir);
		}
	else {
		# Just update the users and groups file paths, realm and
		# require directive
		&foreign_call($apachemod, "save_directive",
			      $auf, [ $file ],
					$conf, $conf);
		&foreign_call($apachemod, "save_directive",
			      $agf, $gfile ? [ $gfile ] : [ ],
					$conf, $conf);
		&foreign_call($apachemod, "save_directive",
			      "AuthName", [ "\"$in{'realm'}\"" ],
					$conf, $conf);
		&foreign_call($apachemod, "save_directive",
			      "require", [ join(" ", @require) ],
					$conf, $conf);

		# Update the known directories list
		$dir->[1] = $file;
		$dir->[2] = $in{'crypt'};
		$dir->[3] = $sync if ($can_sync);
		}

	# Create an empty users file if needed
	if (!-r $file) {
		&lock_file($file);
		&open_tempfile(FILE, ">$file", 1, 1) ||
			&error(&text('dir_ehtpasswd', $file, $!));
		&close_tempfile(FILE) ||
			&error(&text('dir_ehtpasswd', $file, $!));
		&unlock_file($file);
		}

	# Create an empty groups file if needed
	if ($gfile && !-r $gfile) {
		&lock_file($gfile);
		&open_tempfile(FILE, ">$gfile", 1, 1) ||
			&error(&text('dir_ehtgroup', $gfile, $!));
		&close_tempfile(FILE) ||
			&error(&text('dir_ehtgroup', $gfile, $!));
		&unlock_file($gfile);
		}
	}

&flush_file_lines();
&switch_back();

&save_directories(\@dirs);
&unlock_all_files();
&webmin_log($in{'delete'} ? "delete" : $in{'new'} ? "create" : "modify",
	    "dir", $dir->[0]);
&redirect("");

